/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.apache.commons.math3.RealFieldElement;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.SeriesTerm;

class TideTerm<T extends RealFieldElement<T>>
extends SeriesTerm<T> {
    private final int cGamma;
    private final int cL;
    private final int cLPrime;
    private final int cF;
    private final int cD;
    private final int cOmega;

    public TideTerm(int cGamma, int cL, int cLPrime, int cF, int cD, int cOmega) {
        this.cGamma = cGamma;
        this.cL = cL;
        this.cLPrime = cLPrime;
        this.cF = cF;
        this.cD = cD;
        this.cOmega = cOmega;
    }

    @Override
    protected double argument(BodiesElements elements) {
        return (double)this.cGamma * elements.getGamma() + (double)this.cL * elements.getL() + (double)this.cLPrime * elements.getLPrime() + (double)this.cF * elements.getF() + (double)this.cD * elements.getD() + (double)this.cOmega * elements.getOmega();
    }

    @Override
    protected T argument(FieldBodiesElements<T> elements) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elements.getGamma().multiply(this.cGamma)).add(elements.getL().multiply(this.cL))).add(elements.getLPrime().multiply(this.cLPrime))).add(elements.getF().multiply(this.cF))).add(elements.getD().multiply(this.cD))).add(elements.getOmega().multiply(this.cOmega)));
    }
}

