/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.UnsupportedAddressTypeException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.math3.exception.util.DummyLocalizable;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.errors.OrekitException;

public class ZipJarCrawler
implements DataProvider {
    private final File file;
    private final String resource;
    private final ClassLoader classLoader;
    private final URL url;
    private final String name;

    public ZipJarCrawler(File file) {
        this.file = file;
        this.resource = null;
        this.classLoader = null;
        this.url = null;
        this.name = file.getAbsolutePath();
    }

    public ZipJarCrawler(String resource) throws OrekitException {
        this(ZipJarCrawler.class.getClassLoader(), resource);
    }

    public ZipJarCrawler(ClassLoader classLoader, String resource) throws OrekitException {
        try {
            this.file = null;
            this.resource = resource;
            this.classLoader = classLoader;
            this.url = null;
            this.name = classLoader.getResource(resource).toURI().toString();
        }
        catch (URISyntaxException use) {
            throw new OrekitException(use, (Localizable)LocalizedFormats.SIMPLE_MESSAGE, use.getMessage());
        }
    }

    public ZipJarCrawler(URL url) throws OrekitException {
        try {
            this.file = null;
            this.resource = null;
            this.classLoader = null;
            this.url = url;
            this.name = url.toURI().toString();
        }
        catch (URISyntaxException use) {
            throw new OrekitException(use, (Localizable)LocalizedFormats.SIMPLE_MESSAGE, use.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean feed(Pattern supported, DataLoader visitor) throws OrekitException {
        boolean bl;
        block7: {
            Archive archive = null;
            try {
                archive = this.file != null ? new Archive(new FileInputStream(this.file)) : (this.resource != null ? new Archive(this.classLoader.getResourceAsStream(this.resource)) : new Archive(this.url.openConnection().getInputStream()));
                bl = this.feed(this.name, supported, visitor, archive);
                if (archive == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (archive != null) {
                        archive.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
                }
                catch (ParseException pe) {
                    throw new OrekitException(pe, (Localizable)new DummyLocalizable(pe.getMessage()), new Object[0]);
                }
            }
            archive.close();
        }
        return bl;
    }

    private boolean feed(String prefix, Pattern supported, DataLoader visitor, Archive archive) throws OrekitException, IOException, ParseException {
        OrekitException delayedException = null;
        boolean loaded = false;
        for (Archive.EntryStream entry : archive) {
            try {
                if (visitor.stillAcceptsData() && !entry.isDirectory()) {
                    String fullName = prefix + "!" + entry.getName();
                    if (ZIP_ARCHIVE_PATTERN.matcher(entry.getName()).matches()) {
                        loaded = this.feed(fullName, supported, visitor, new Archive(entry)) || loaded;
                    } else {
                        Matcher gzipMatcher;
                        String baseName;
                        String entryName = entry.getName();
                        int lastSlash = entryName.lastIndexOf(47);
                        if (lastSlash >= 0) {
                            entryName = entryName.substring(lastSlash + 1);
                        }
                        String string = baseName = (gzipMatcher = GZIP_FILE_PATTERN.matcher(entryName)).matches() ? gzipMatcher.group(1) : entryName;
                        if (supported.matcher(baseName).matches()) {
                            InputStream stream = gzipMatcher.matches() ? new GZIPInputStream(entry) : entry;
                            visitor.loadData(stream, fullName);
                            stream.close();
                            loaded = true;
                        }
                    }
                }
            }
            catch (OrekitException oe) {
                delayedException = oe;
            }
            entry.close();
        }
        if (!loaded && delayedException != null) {
            throw delayedException;
        }
        return loaded;
    }

    private static final class Archive
    implements Closeable,
    Iterable<EntryStream> {
        private final ZipInputStream zip;
        private EntryStream next;

        public Archive(InputStream rawStream) throws IOException {
            this.zip = new ZipInputStream(rawStream);
            this.goToNext();
        }

        private void goToNext() throws IOException {
            ZipEntry ze = this.zip.getNextEntry();
            this.next = ze == null ? null : new EntryStream(ze.getName(), ze.isDirectory());
        }

        @Override
        public Iterator<EntryStream> iterator() {
            return new Iterator<EntryStream>(){

                @Override
                public boolean hasNext() {
                    return Archive.this.next != null;
                }

                @Override
                public EntryStream next() throws NoSuchElementException {
                    if (Archive.this.next == null) {
                        throw new NoSuchElementException();
                    }
                    return Archive.this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedAddressTypeException();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.zip.close();
        }

        public class EntryStream
        extends InputStream {
            private final String name;
            private boolean isDirectory;
            private boolean closed;

            public EntryStream(String name, boolean isDirectory) {
                this.name = name;
                this.isDirectory = isDirectory;
                this.closed = false;
            }

            public String getName() {
                return this.name;
            }

            public boolean isDirectory() {
                return this.isDirectory;
            }

            @Override
            public int read() throws IOException {
                return Archive.this.zip.read();
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    Archive.this.zip.closeEntry();
                    Archive.this.goToNext();
                    this.closed = true;
                }
            }
        }
    }
}

