/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.errors;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.math3.exception.util.ExceptionContext;
import org.apache.commons.math3.exception.util.ExceptionContextProvider;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.errors.OrekitMessages;

public class OrekitException
extends Exception {
    private static final long serialVersionUID = 3366757982695469677L;
    private final ExceptionContext context;
    private final Localizable specifier;
    private final Object[] parts;

    public OrekitException(Localizable specifier, Object ... parts) {
        this.context = null;
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public OrekitException(OrekitException exception) {
        super(exception);
        this.context = exception.context;
        this.specifier = exception.specifier;
        this.parts = (Object[])exception.parts.clone();
    }

    public OrekitException(Localizable message, Throwable cause) {
        super(cause);
        this.context = null;
        this.specifier = message;
        this.parts = new Object[0];
    }

    public OrekitException(Throwable cause, Localizable specifier, Object ... parts) {
        super(cause);
        this.context = null;
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public OrekitException(ExceptionContextProvider provider) {
        super(provider.getContext().getThrowable());
        this.context = provider.getContext();
        this.specifier = null;
        this.parts = new Object[0];
    }

    public String getMessage(Locale locale) {
        return this.context != null ? this.context.getMessage(locale) : OrekitException.buildMessage(locale, this.specifier, this.parts);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public Localizable getSpecifier() {
        return this.specifier;
    }

    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    private static String buildMessage(Locale locale, Localizable specifier, Object ... parts) {
        return specifier == null ? "" : new MessageFormat(specifier.getLocalizedString(locale), locale).format(parts);
    }

    public static IllegalArgumentException createIllegalArgumentException(final Localizable specifier, final Object ... parts) {
        return new IllegalArgumentException(){
            private static final long serialVersionUID = 2601215225271704045L;

            @Override
            public String getMessage() {
                return OrekitException.buildMessage(Locale.US, specifier, parts);
            }

            @Override
            public String getLocalizedMessage() {
                return OrekitException.buildMessage(Locale.getDefault(), specifier, parts);
            }
        };
    }

    public static IllegalStateException createIllegalStateException(final Localizable specifier, final Object ... parts) {
        return new IllegalStateException(){
            private static final long serialVersionUID = -5527779242879685212L;

            @Override
            public String getMessage() {
                return OrekitException.buildMessage(Locale.US, specifier, parts);
            }

            @Override
            public String getLocalizedMessage() {
                return OrekitException.buildMessage(Locale.getDefault(), specifier, parts);
            }
        };
    }

    public static ParseException createParseException(final Localizable specifier, final Object ... parts) {
        return new ParseException("", 0){
            private static final long serialVersionUID = 4771367217940584391L;

            @Override
            public String getMessage() {
                return OrekitException.buildMessage(Locale.US, specifier, parts);
            }

            @Override
            public String getLocalizedMessage() {
                return OrekitException.buildMessage(Locale.getDefault(), specifier, parts);
            }
        };
    }

    public static RuntimeException createInternalError(Throwable cause) {
        final OrekitMessages specifier = OrekitMessages.INTERNAL_ERROR;
        String parts = "orekit@c-s.fr";
        return new RuntimeException(){
            private static final long serialVersionUID = -6493358459835909138L;

            @Override
            public String getMessage() {
                return OrekitException.buildMessage(Locale.US, specifier, new Object[]{"orekit@c-s.fr"});
            }

            @Override
            public String getLocalizedMessage() {
                return OrekitException.buildMessage(Locale.getDefault(), specifier, new Object[]{"orekit@c-s.fr"});
            }
        };
    }
}

