/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.apache.commons.math3.exception.util.DummyLocalizable;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.Atmosphere;
import org.orekit.forces.drag.DTM2000InputParameters;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;

public class DTM2000
implements Atmosphere {
    public static final int HYDROGEN = 1;
    public static final int HELIUM = 2;
    public static final int ATOMIC_OXYGEN = 3;
    public static final int MOLECULAR_NITROGEN = 4;
    public static final int MOLECULAR_OXYGEN = 5;
    public static final int ATOMIC_NITROGEN = 6;
    private static final long serialVersionUID = -8901940398967553588L;
    private static final int NLATM = 96;
    private static final double[] ALEFA = new double[]{0.0, -0.4, -0.38, 0.0, 0.0, 0.0, 0.0};
    private static final double[] MA = new double[]{0.0, 1.0, 4.0, 16.0, 28.0, 32.0, 14.0};
    private static final double[] VMA = new double[]{0.0, 1.6606E-24, 6.6423E-24, 2.6569E-23, 4.64958E-23, 5.31381E-23, 2.32479E-23};
    private static final double RE = 6356.77;
    private static final double ZLB0 = 120.0;
    private static final double CPMG = 0.19081;
    private static final double SPMG = 0.98163;
    private static final double XLMG = -1.2392;
    private static final double GSURF = 980.665;
    private static final double RGAS = 831.4;
    private static final double ROT = 0.017214206;
    private static final double ROT2 = 0.034428412;
    private static final String DTM2000 = "/assets/org/orekit/dtm_2000.txt";
    private static double[] tt = null;
    private static double[] h = null;
    private static double[] he = null;
    private static double[] o = null;
    private static double[] az2 = null;
    private static double[] o2 = null;
    private static double[] az = null;
    private static double[] t0 = null;
    private static double[] tp = null;
    private static double[] dtt = null;
    private static double[] dh = null;
    private static double[] dhe = null;
    private static double[] dox = null;
    private static double[] daz2 = null;
    private static double[] do2 = null;
    private static double[] daz = null;
    private static double[] dt0 = null;
    private static double[] dtp = null;
    private int cachedDay;
    private double[] cachedF = new double[3];
    private double[] cachedFbar = new double[3];
    private double[] akp = new double[5];
    private double cachedAlti;
    private double cachedHl;
    private double alat;
    private double xlon;
    private double tz;
    private double tinf;
    private double tp120;
    private double ro;
    private double wmm;
    private double[] d = new double[7];
    private double p10;
    private double p20;
    private double p30;
    private double p40;
    private double p50;
    private double p60;
    private double p11;
    private double p21;
    private double p31;
    private double p41;
    private double p51;
    private double p22;
    private double p32;
    private double p42;
    private double p52;
    private double p62;
    private double p33;
    private double p10mg;
    private double p20mg;
    private double p40mg;
    private double hl0;
    private double ch;
    private double sh;
    private double c2h;
    private double s2h;
    private double c3h;
    private double s3h;
    private PVCoordinatesProvider sun;
    private DTM2000InputParameters inputParams;
    private BodyShape earth;

    public DTM2000(DTM2000InputParameters parameters, PVCoordinatesProvider sun, BodyShape earth) throws OrekitException {
        this.earth = earth;
        this.sun = sun;
        this.inputParams = parameters;
        if (tt == null) {
            org.orekit.forces.drag.DTM2000.readcoefficients();
        }
    }

    @Override
    public Frame getFrame() {
        return this.earth.getBodyFrame();
    }

    public double getDensity(int day, double alti, double lon, double lat, double hl, double f, double fbar, double akp3, double akp24) throws OrekitException {
        double threshold = 120000.0;
        if (alti < 120000.0) {
            throw new OrekitException((Localizable)OrekitMessages.ALTITUDE_BELOW_ALLOWED_THRESHOLD, alti, 120000.0);
        }
        this.cachedDay = day;
        this.cachedAlti = alti / 1000.0;
        this.xlon = lon;
        this.alat = lat;
        this.cachedHl = hl;
        this.cachedF[1] = f;
        this.cachedFbar[1] = fbar;
        this.akp[1] = akp3;
        this.akp[3] = akp24;
        this.computation();
        return this.ro * 1000.0;
    }

    private void computation() {
        this.ro = 0.0;
        double zlb = 120.0;
        double c = FastMath.sin((double)this.alat);
        double c2 = c * c;
        double c4 = c2 * c2;
        double s = FastMath.cos((double)this.alat);
        double s2 = s * s;
        this.p10 = c;
        this.p20 = 1.5 * c2 - 0.5;
        this.p30 = c * (2.5 * c2 - 1.5);
        this.p40 = 4.375 * c4 - 3.75 * c2 + 0.375;
        this.p50 = c * (7.875 * c4 - 8.75 * c2 + 1.875);
        this.p60 = (5.5 * c * this.p50 - 2.5 * this.p40) / 3.0;
        this.p11 = s;
        this.p21 = 3.0 * c * s;
        this.p31 = s * (7.5 * c2 - 1.5);
        this.p41 = c * s * (17.5 * c2 - 7.5);
        this.p51 = s * (39.375 * c4 - 26.25 * c2 + 1.875);
        this.p22 = 3.0 * s2;
        this.p32 = 15.0 * c * s2;
        this.p42 = s2 * (52.5 * c2 - 7.5);
        this.p52 = 3.0 * c * this.p42 - 2.0 * this.p32;
        this.p62 = 2.75 * c * this.p52 - 1.75 * this.p42;
        this.p33 = 15.0 * s * s2;
        double clmlmg = FastMath.cos((double)(this.xlon - -1.2392));
        double cmg = s * 0.19081 * clmlmg + c * 0.98163;
        double cmg2 = cmg * cmg;
        double cmg4 = cmg2 * cmg2;
        this.p10mg = cmg;
        this.p20mg = 1.5 * cmg2 - 0.5;
        this.p40mg = 4.375 * cmg4 - 3.75 * cmg2 + 0.375;
        this.hl0 = this.cachedHl;
        this.ch = FastMath.cos((double)this.hl0);
        this.sh = FastMath.sin((double)this.hl0);
        this.c2h = this.ch * this.ch - this.sh * this.sh;
        this.s2h = 2.0 * this.ch * this.sh;
        this.c3h = this.c2h * this.ch - this.s2h * this.sh;
        this.s3h = this.s2h * this.ch + this.c2h * this.sh;
        int kleq = 1;
        double gdelt = this.gFunction(tt, dtt, 1, kleq);
        org.orekit.forces.drag.DTM2000.dtt[1] = 1.0 + gdelt;
        this.tinf = tt[1] * dtt[1];
        kleq = 0;
        if (this.cachedDay < 59 || this.cachedDay > 284) {
            kleq = -1;
        }
        if (this.cachedDay > 99 && this.cachedDay < 244) {
            kleq = 1;
        }
        double gdelt0 = this.gFunction(t0, dt0, 0, kleq);
        org.orekit.forces.drag.DTM2000.dt0[1] = (t0[1] + gdelt0) / t0[1];
        double t120 = t0[1] + gdelt0;
        double gdeltp = this.gFunction(tp, dtp, 0, kleq);
        org.orekit.forces.drag.DTM2000.dtp[1] = (tp[1] + gdeltp) / tp[1];
        this.tp120 = tp[1] + gdeltp;
        double sigma = this.tp120 / (this.tinf - t120);
        double dzeta = 6476.77 / (6356.77 + this.cachedAlti);
        double zeta = (this.cachedAlti - 120.0) * dzeta;
        double sigzeta = sigma * zeta;
        double expsz = FastMath.exp((double)(-sigzeta));
        this.tz = this.tinf - (this.tinf - t120) * expsz;
        double[] dbase = new double[7];
        kleq = 1;
        double gdelh = this.gFunction(h, dh, 0, kleq);
        org.orekit.forces.drag.DTM2000.dh[1] = FastMath.exp((double)gdelh);
        dbase[1] = h[1] * dh[1];
        double gdelhe = this.gFunction(he, dhe, 0, kleq);
        org.orekit.forces.drag.DTM2000.dhe[1] = FastMath.exp((double)gdelhe);
        dbase[2] = he[1] * dhe[1];
        double gdelo = this.gFunction(o, dox, 1, kleq);
        org.orekit.forces.drag.DTM2000.dox[1] = FastMath.exp((double)gdelo);
        dbase[3] = o[1] * dox[1];
        double gdelaz2 = this.gFunction(az2, daz2, 1, kleq);
        org.orekit.forces.drag.DTM2000.daz2[1] = FastMath.exp((double)gdelaz2);
        dbase[4] = az2[1] * daz2[1];
        double gdelo2 = this.gFunction(o2, do2, 1, kleq);
        org.orekit.forces.drag.DTM2000.do2[1] = FastMath.exp((double)gdelo2);
        dbase[5] = o2[1] * do2[1];
        double gdelaz = this.gFunction(az, daz, 1, kleq);
        org.orekit.forces.drag.DTM2000.daz[1] = FastMath.exp((double)gdelaz);
        dbase[6] = az[1] * daz[1];
        double zlbre = 1.0188775116922588;
        double glb = 944.6626010205721 / (sigma * 831.4 * this.tinf);
        double t120tz = t120 / this.tz;
        double[] cc = new double[7];
        double[] fz = new double[7];
        for (int i = 1; i <= 6; ++i) {
            double gamma = MA[i] * glb;
            double upapg = 1.0 + ALEFA[i] + gamma;
            fz[i] = FastMath.pow((double)t120tz, (double)upapg) * FastMath.exp((double)(-sigzeta * gamma));
            cc[i] = dbase[i] * fz[i];
            this.d[i] = cc[i] * VMA[i];
            this.ro += this.d[i];
        }
        this.wmm = this.ro / (VMA[1] * (cc[1] + cc[2] + cc[3] + cc[4] + cc[5] + cc[6]));
    }

    private double gFunction(double[] a, double[] da, int ff0, int kle_eq) {
        double[] fmfb = new double[3];
        double[] fbm150 = new double[3];
        da[2] = this.p20;
        da[3] = this.p40;
        da[74] = this.p10;
        double a74 = a[74];
        double a77 = a[77];
        double a78 = a[78];
        if (kle_eq == -1) {
            a74 = -a74;
            a77 = -a77;
            a78 = -a78;
        }
        if (kle_eq == 0) {
            a74 = this.semestrialCorrection(a74);
            a77 = this.semestrialCorrection(a77);
            a78 = this.semestrialCorrection(a78);
        }
        da[77] = this.p30;
        da[78] = this.p50;
        da[79] = this.p60;
        fmfb[1] = this.cachedF[1] - this.cachedFbar[1];
        fmfb[2] = this.cachedF[2] - this.cachedFbar[2];
        fbm150[1] = this.cachedFbar[1] - 150.0;
        fbm150[2] = this.cachedFbar[2];
        da[4] = fmfb[1];
        da[6] = fbm150[1];
        da[4] = da[4] + a[70] * fmfb[2];
        da[6] = da[6] + a[71] * fbm150[2];
        da[70] = fmfb[2] * (a[4] + 2.0 * a[5] * da[4] + a[82] * this.p10 + a[83] * this.p20 + a[84] * this.p30);
        da[71] = fbm150[2] * (a[6] + 2.0 * a[69] * da[6] + a[85] * this.p10 + a[86] * this.p20 + a[87] * this.p30);
        da[5] = da[4] * da[4];
        da[69] = da[6] * da[6];
        da[82] = da[4] * this.p10;
        da[83] = da[4] * this.p20;
        da[84] = da[4] * this.p30;
        da[85] = da[6] * this.p20;
        da[86] = da[6] * this.p30;
        da[87] = da[6] * this.p40;
        int ikp = 62;
        int ikpm = 67;
        double c2fi = 1.0 - this.p10mg * this.p10mg;
        double dkp = this.akp[1] + (a[62] + c2fi * a[63]) * this.akp[2];
        double dakp = a[7] + a[8] * this.p20mg + a[68] * this.p40mg + 2.0 * dkp * (a[60] + a[61] * this.p20mg + a[75] * 2.0 * dkp * dkp);
        da[62] = dakp * this.akp[2];
        da[63] = da[62] * c2fi;
        double dkpm = this.akp[3] + a[67] * this.akp[4];
        double dakpm = a[64] + a[65] * this.p20mg + a[72] * this.p40mg + 2.0 * dkpm * (a[66] + a[73] * this.p20mg + a[76] * 2.0 * dkpm * dkpm);
        da[67] = dakpm * this.akp[4];
        da[7] = dkp;
        da[8] = this.p20mg * dkp;
        da[68] = this.p40mg * dkp;
        da[60] = dkp * dkp;
        da[61] = this.p20mg * da[60];
        da[75] = da[60] * da[60];
        da[64] = dkpm;
        da[65] = this.p20mg * dkpm;
        da[72] = this.p40mg * dkpm;
        da[66] = dkpm * dkpm;
        da[73] = this.p20mg * da[66];
        da[76] = da[66] * da[66];
        double f0 = a[4] * da[4] + a[5] * da[5] + a[6] * da[6] + a[69] * da[69] + a[82] * da[82] + a[83] * da[83] + a[84] * da[84] + a[85] * da[85] + a[86] * da[86] + a[87] * da[87];
        double f1f = 1.0 + f0 * (double)ff0;
        f0 = f0 + a[2] * da[2] + a[3] * da[3] + a74 * da[74] + a77 * da[77] + a[7] * da[7] + a[8] * da[8] + a[60] * da[60] + a[61] * da[61] + a[68] * da[68] + a[64] * da[64] + a[65] * da[65] + a[66] * da[66] + a[72] * da[72] + a[73] * da[73] + a[75] * da[75] + a[76] * da[76] + a78 * da[78] + a[79] * da[79];
        da[9] = FastMath.cos((double)(0.017214206 * ((double)this.cachedDay - a[11])));
        da[10] = this.p20 * da[9];
        da[12] = FastMath.cos((double)(0.034428412 * ((double)this.cachedDay - a[14])));
        da[13] = this.p20 * da[12];
        double coste = FastMath.cos((double)(0.017214206 * ((double)this.cachedDay - a[18])));
        da[15] = this.p10 * coste;
        da[16] = this.p30 * coste;
        da[17] = this.p50 * coste;
        double cos2te = FastMath.cos((double)(0.034428412 * ((double)this.cachedDay - a[20])));
        da[19] = this.p10 * cos2te;
        da[39] = this.p30 * cos2te;
        da[59] = this.p50 * cos2te;
        da[21] = this.p11 * this.ch;
        da[22] = this.p31 * this.ch;
        da[23] = this.p51 * this.ch;
        da[24] = da[21] * coste;
        da[25] = this.p21 * this.ch * coste;
        da[26] = this.p11 * this.sh;
        da[27] = this.p31 * this.sh;
        da[28] = this.p51 * this.sh;
        da[29] = da[26] * coste;
        da[30] = this.p21 * this.sh * coste;
        da[31] = this.p22 * this.c2h;
        da[37] = this.p42 * this.c2h;
        da[32] = this.p32 * this.c2h * coste;
        da[33] = this.p22 * this.s2h;
        da[38] = this.p42 * this.s2h;
        da[34] = this.p32 * this.s2h * coste;
        da[88] = this.p32 * this.c2h;
        da[89] = this.p32 * this.s2h;
        da[90] = this.p52 * this.c2h;
        da[91] = this.p52 * this.s2h;
        double a88 = a[88];
        double a89 = a[89];
        double a90 = a[90];
        double a91 = a[91];
        if (kle_eq == -1) {
            a88 = -a88;
            a89 = -a89;
            a90 = -a90;
            a91 = -a91;
        }
        if (kle_eq == 0) {
            a88 = this.semestrialCorrection(a88);
            a89 = this.semestrialCorrection(a89);
            a90 = this.semestrialCorrection(a90);
            a91 = this.semestrialCorrection(a91);
        }
        da[92] = this.p62 * this.c2h;
        da[93] = this.p62 * this.s2h;
        da[35] = this.p33 * this.c3h;
        da[36] = this.p33 * this.s3h;
        double fp = a[9] * da[9] + a[10] * da[10] + a[12] * da[12] + a[13] * da[13] + a[15] * da[15] + a[16] * da[16] + a[17] * da[17] + a[19] * da[19] + a[21] * da[21] + a[22] * da[22] + a[23] * da[23] + a[24] * da[24] + a[25] * da[25] + a[26] * da[26] + a[27] * da[27] + a[28] * da[28] + a[29] * da[29] + a[30] * da[30] + a[31] * da[31] + a[32] * da[32] + a[33] * da[33] + a[34] * da[34] + a[35] * da[35] + a[36] * da[36] + a[37] * da[37] + a[38] * da[38] + a[39] * da[39] + a[59] * da[59] + a88 * da[88] + a89 * da[89] + a90 * da[90] + a91 * da[91] + a[92] * da[92] + a[93] * da[93];
        da[40] = this.p10 * coste * dkp;
        da[41] = this.p30 * coste * dkp;
        da[42] = this.p50 * coste * dkp;
        da[43] = this.p11 * this.ch * dkp;
        da[44] = this.p31 * this.ch * dkp;
        da[45] = this.p51 * this.ch * dkp;
        da[46] = this.p11 * this.sh * dkp;
        da[47] = this.p31 * this.sh * dkp;
        da[48] = this.p51 * this.sh * dkp;
        fp += a[40] * da[40] + a[41] * da[41] + a[42] * da[42] + a[43] * da[43] + a[44] * da[44] + a[45] * da[45] + a[46] * da[46] + a[47] * da[47] + a[48] * da[48];
        dakp = (a[40] * this.p10 + a[41] * this.p30 + a[42] * this.p50) * coste + (a[43] * this.p11 + a[44] * this.p31 + a[45] * this.p51) * this.ch + (a[46] * this.p11 + a[47] * this.p31 + a[48] * this.p51) * this.sh;
        da[62] = da[62] + dakp * this.akp[2];
        da[63] = da[62] + dakp * c2fi * this.akp[2];
        double clfl = FastMath.cos((double)this.xlon);
        da[49] = this.p11 * clfl;
        da[50] = this.p21 * clfl;
        da[51] = this.p31 * clfl;
        da[52] = this.p41 * clfl;
        da[53] = this.p51 * clfl;
        double slfl = FastMath.sin((double)this.xlon);
        da[54] = this.p11 * slfl;
        da[55] = this.p21 * slfl;
        da[56] = this.p31 * slfl;
        da[57] = this.p41 * slfl;
        da[58] = this.p51 * slfl;
        return f0 + (fp += a[49] * da[49] + a[50] * da[50] + a[51] * da[51] + a[52] * da[52] + a[53] * da[53] + a[54] * da[54] + a[55] * da[55] + a[56] * da[56] + a[57] * da[57] + a[58] * da[58]) * f1f;
    }

    private double semestrialCorrection(double param) {
        double result;
        int debeq_pr = 59;
        int debeq_au = 244;
        if (this.cachedDay >= 100) {
            double xmult = (double)(this.cachedDay - 244) / 40.0;
            result = param - 2.0 * param * xmult;
        } else {
            double xmult = (double)(this.cachedDay - 59) / 40.0;
            result = 2.0 * param * xmult - param;
        }
        return result;
    }

    private static void readcoefficients() throws OrekitException {
        int size = 97;
        tt = new double[97];
        h = new double[97];
        he = new double[97];
        o = new double[97];
        az2 = new double[97];
        o2 = new double[97];
        az = new double[97];
        t0 = new double[97];
        tp = new double[97];
        dtt = new double[97];
        dh = new double[97];
        dhe = new double[97];
        dox = new double[97];
        daz2 = new double[97];
        do2 = new double[97];
        daz = new double[97];
        dt0 = new double[97];
        dtp = new double[97];
        Arrays.fill(dtt, Double.NaN);
        Arrays.fill(dh, Double.NaN);
        Arrays.fill(dhe, Double.NaN);
        Arrays.fill(dox, Double.NaN);
        Arrays.fill(daz2, Double.NaN);
        Arrays.fill(do2, Double.NaN);
        Arrays.fill(daz, Double.NaN);
        Arrays.fill(dt0, Double.NaN);
        Arrays.fill(dtp, Double.NaN);
        InputStream in = DTM2000.class.getResourceAsStream(DTM2000);
        if (in == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, DTM2000);
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            r.readLine();
            r.readLine();
            String line = r.readLine();
            while (line != null) {
                int num = Integer.parseInt(line.substring(0, 4).replace(' ', '0'));
                line = line.substring(4);
                org.orekit.forces.drag.DTM2000.tt[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.h[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.he[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.o[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.az2[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.o2[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.az[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.t0[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = line.substring(22);
                org.orekit.forces.drag.DTM2000.tp[num] = Double.parseDouble(line.substring(0, 13).replace(' ', '0'));
                line = r.readLine();
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
                }
            }
        }
    }

    public double getTinf() {
        return this.tinf;
    }

    public double getT() {
        return this.tz;
    }

    public double getMam() {
        return this.wmm;
    }

    public double getPartialDensities(int identifier) {
        if (identifier < 1 || identifier > 6) {
            throw new IllegalArgumentException("element identifier is not correct");
        }
        return this.d[identifier] * 1000.0;
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) throws OrekitException {
        if (date.compareTo(this.inputParams.getMaxDate()) > 0 || date.compareTo(this.inputParams.getMinDate()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SOLAR_ACTIVITY_AT_DATE, date, this.inputParams.getMinDate(), this.inputParams.getMaxDate());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date.toDate(TimeScalesFactory.getUTC()));
        int day = cal.get(6);
        GeodeticPoint inBody = this.earth.transform(position, frame, date);
        double alti = inBody.getAltitude();
        double lon = inBody.getLongitude();
        double lat = inBody.getLatitude();
        Vector3D sunPos = this.sun.getPVCoordinates(date, frame).getPosition();
        double hl = Math.PI + FastMath.atan2((double)(sunPos.getX() * position.getY() - sunPos.getY() * position.getX()), (double)(sunPos.getX() * position.getX() + sunPos.getY() * position.getY()));
        return this.getDensity(day, alti, lon, lat, hl, this.inputParams.getInstantFlux(date), this.inputParams.getMeanFlux(date), this.inputParams.getThreeHourlyKP(date), this.inputParams.get24HoursKp(date));
    }

    @Override
    public Vector3D getVelocity(AbsoluteDate date, Vector3D position, Frame frame) throws OrekitException {
        Transform bodyToFrame = this.earth.getBodyFrame().getTransformTo(frame, date);
        Vector3D posInBody = bodyToFrame.getInverse().transformPosition(position);
        PVCoordinates pvBody = new PVCoordinates(posInBody, new Vector3D(0.0, 0.0, 0.0));
        PVCoordinates pvFrame = bodyToFrame.transformPVCoordinates(pvBody);
        return pvFrame.getVelocity();
    }
}

