/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.DTM2000InputParameters;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;

public class MarshallSolarActivityFutureEstimation
implements DTM2000InputParameters,
DataLoader {
    private static final long serialVersionUID = -5212198874900835369L;
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double[] KP_ARRAY = new double[]{0.0, 0.3333333333333333, 0.6666666666666667, 1.0, 1.3333333333333333, 1.6666666666666667, 2.0, 2.3333333333333335, 2.6666666666666665, 3.0, 3.3333333333333335, 3.6666666666666665, 4.0, 4.333333333333333, 4.666666666666667, 5.0, 5.333333333333333, 5.666666666666667, 6.0, 6.333333333333333, 6.666666666666667, 7.0, 7.333333333333333, 7.666666666666667, 8.0, 8.333333333333334, 8.666666666666666, 9.0};
    private static final double[] AP_ARRAY = new double[]{0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 12.0, 15.0, 18.0, 22.0, 27.0, 32.0, 39.0, 48.0, 56.0, 67.0, 80.0, 94.0, 111.0, 132.0, 154.0, 179.0, 207.0, 236.0, 300.0, 400.0};
    private final Pattern dataPattern;
    private final SortedSet<TimeStamped> data = new TreeSet<TimeStamped>(new ChronologicalComparator());
    private final StrengthLevel strengthLevel;
    private AbsoluteDate firstDate = null;
    private AbsoluteDate lastDate = null;
    private LineParameters previousParam;
    private LineParameters currentParam;
    private final String supportedNames;

    public MarshallSolarActivityFutureEstimation(String supportedNames, StrengthLevel strengthLevel) {
        this.supportedNames = supportedNames;
        this.strengthLevel = strengthLevel;
        StringBuilder builder = new StringBuilder("^");
        builder.append("\\p{Blank}*(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})");
        builder.append("\\.\\p{Digit}+");
        builder.append("\\p{Blank}+(");
        for (Month month : Month.values()) {
            builder.append(month.getUpperCaseAbbreviation());
            builder.append('|');
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(")");
        for (int i = 0; i < 6; ++i) {
            builder.append("\\p{Blank}+([-+]?[0-9]+\\.[0-9]+)");
        }
        builder.append("\\p{Blank}*$");
        this.dataPattern = Pattern.compile(builder.toString());
    }

    public StrengthLevel getStrengthLevel() {
        return this.strengthLevel;
    }

    private void bracketDate(AbsoluteDate date) throws OrekitException {
        if (date.durationFrom(this.firstDate) < 0.0 || date.durationFrom(this.lastDate) > 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, date, this.firstDate, this.lastDate);
        }
        if (this.previousParam != null && date.durationFrom(this.previousParam.getDate()) > 0.0 && date.durationFrom(this.currentParam.getDate()) <= 0.0) {
            return;
        }
        if (date.equals(this.firstDate)) {
            this.currentParam = (LineParameters)this.data.tailSet(date.shiftedBy(1.0)).first();
            this.previousParam = (LineParameters)this.data.first();
        } else if (date.equals(this.lastDate)) {
            this.currentParam = (LineParameters)this.data.last();
            this.previousParam = (LineParameters)this.data.headSet(date.shiftedBy(-1.0)).last();
        } else {
            this.currentParam = (LineParameters)this.data.tailSet(date).first();
            this.previousParam = (LineParameters)this.data.headSet(date).last();
        }
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    @Override
    public double getInstantFlux(AbsoluteDate date) throws OrekitException {
        return this.getMeanFlux(date);
    }

    @Override
    public double getMeanFlux(AbsoluteDate date) throws OrekitException {
        this.bracketDate(date);
        AbsoluteDate previousDate = this.previousParam.getDate();
        AbsoluteDate currentDate = this.currentParam.getDate();
        double dt = currentDate.durationFrom(previousDate);
        double previousF107 = this.previousParam.getF107();
        double currentF107 = this.currentParam.getF107();
        double previousWeight = currentDate.durationFrom(date) / dt;
        double currentWeight = date.durationFrom(previousDate) / dt;
        return previousF107 * previousWeight + currentF107 * currentWeight;
    }

    @Override
    public double getThreeHourlyKP(AbsoluteDate date) throws OrekitException {
        return this.get24HoursKp(date);
    }

    public DateComponents getFileDate(AbsoluteDate date) throws OrekitException {
        this.bracketDate(date);
        double dtP = date.durationFrom(this.previousParam.getDate());
        double dtC = this.currentParam.getDate().durationFrom(date);
        return dtP < dtC ? this.previousParam.getFileDate() : this.currentParam.getFileDate();
    }

    @Override
    public double get24HoursKp(AbsoluteDate date) throws OrekitException {
        this.bracketDate(date);
        AbsoluteDate previousDate = this.previousParam.getDate();
        AbsoluteDate currentDate = this.currentParam.getDate();
        double dt = currentDate.durationFrom(previousDate);
        double previousAp = this.previousParam.getAp();
        double currentAp = this.currentParam.getAp();
        double previousWeight = currentDate.durationFrom(date) / dt;
        double currentWeight = date.durationFrom(previousDate) / dt;
        double ap = previousAp * previousWeight + currentAp * currentWeight;
        int i = Arrays.binarySearch(AP_ARRAY, ap);
        if (i >= 0) {
            return KP_ARRAY[i];
        }
        int jSup = -(i + 1);
        int jInf = jSup - 1;
        if (ap - AP_ARRAY[jInf] < AP_ARRAY[jSup] - ap) {
            return KP_ARRAY[jInf];
        }
        return KP_ARRAY[jSup];
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int apGroup;
        int f107Group;
        switch (this.strengthLevel) {
            case STRONG: {
                f107Group = 3;
                apGroup = 6;
                break;
            }
            case AVERAGE: {
                f107Group = 4;
                apGroup = 7;
                break;
            }
            default: {
                f107Group = 5;
                apGroup = 8;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        boolean inData = false;
        UTCScale utc = TimeScalesFactory.getUTC();
        DateComponents fileDate = null;
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                Matcher matcher = this.dataPattern.matcher(line);
                if (matcher.matches()) {
                    inData = true;
                    int year = Integer.parseInt(matcher.group(1));
                    Month month = Month.parseMonth(matcher.group(2));
                    AbsoluteDate date = new AbsoluteDate(year, month, 1, (TimeScale)utc);
                    if (fileDate == null) {
                        fileDate = month.getNumber() > 6 ? new DateComponents(year + 1, month.getNumber() - 6, 1) : new DateComponents(year, month.getNumber() + 6, 1);
                    }
                    boolean addEntry = false;
                    Iterator iterator = this.data.tailSet(date).iterator();
                    if (iterator.hasNext()) {
                        LineParameters existingEntry = (LineParameters)iterator.next();
                        if (existingEntry.getDate().equals(date)) {
                            if (existingEntry.getFileDate().compareTo(fileDate) < 0) {
                                iterator.remove();
                                addEntry = true;
                            }
                        } else {
                            addEntry = true;
                        }
                    } else {
                        addEntry = true;
                    }
                    if (addEntry) {
                        this.data.add(new LineParameters(fileDate, date, Double.parseDouble(matcher.group(f107Group)), Double.parseDouble(matcher.group(apGroup))));
                    }
                } else if (inData) {
                    throw new OrekitException((Localizable)OrekitMessages.NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE, name);
                }
            }
            line = reader.readLine();
        }
        if (this.data.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE, name);
        }
        this.firstDate = this.data.first().getDate();
        this.lastDate = this.data.last().getDate();
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    private static class LineParameters
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = 6607862001953526475L;
        private final DateComponents fileDate;
        private final AbsoluteDate date;
        private final double f107;
        private final double ap;

        private LineParameters(DateComponents fileDate, AbsoluteDate date, double f107, double ap) {
            this.fileDate = fileDate;
            this.date = date;
            this.f107 = f107;
            this.ap = ap;
        }

        public DateComponents getFileDate() {
            return this.fileDate;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getF107() {
            return this.f107;
        }

        public double getAp() {
            return this.ap;
        }
    }

    public static enum StrengthLevel {
        STRONG,
        AVERAGE,
        WEAK;

    }
}

