/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.forces.drag.Atmosphere;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class SimpleExponentialAtmosphere
implements Atmosphere {
    private static final long serialVersionUID = 2772347498196369601L;
    private BodyShape shape;
    private double rho0;
    private double h0;
    private double hscale;

    public SimpleExponentialAtmosphere(BodyShape shape, double rho0, double h0, double hscale) {
        this.shape = shape;
        this.rho0 = rho0;
        this.h0 = h0;
        this.hscale = hscale;
    }

    @Override
    public Frame getFrame() {
        return this.shape.getBodyFrame();
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) throws OrekitException {
        GeodeticPoint gp = this.shape.transform(position, frame, date);
        return this.rho0 * FastMath.exp((double)((this.h0 - gp.getAltitude()) / this.hscale));
    }

    @Override
    public Vector3D getVelocity(AbsoluteDate date, Vector3D position, Frame frame) throws OrekitException {
        Transform bodyToFrame = this.shape.getBodyFrame().getTransformTo(frame, date);
        Vector3D posInBody = bodyToFrame.getInverse().transformPosition(position);
        PVCoordinates pvBody = new PVCoordinates(posInBody, new Vector3D(0.0, 0.0, 0.0));
        PVCoordinates pvFrame = bodyToFrame.transformPVCoordinates(pvBody);
        return pvFrame.getVelocity();
    }
}

