/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.io.Serializable;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.SphericalCoordinates;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TideSystemProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;

public class HolmesFeatherstoneAttractionModel
extends AbstractParameterizable
implements ForceModel,
TideSystemProvider {
    private static final int SCALING = 930;
    private final NormalizedSphericalHarmonicsProvider provider;
    private double mu;
    private final Frame bodyFrame;
    private final double[] gnmOj;
    private final double[] hnmOj;
    private final double[] enm;
    private final double[] sectorial;

    public HolmesFeatherstoneAttractionModel(Frame centralBodyFrame, NormalizedSphericalHarmonicsProvider provider) {
        super(new String[]{"central attraction coefficient"});
        int m;
        this.provider = provider;
        this.mu = provider.getMu();
        this.bodyFrame = centralBodyFrame;
        int degree = provider.getMaxDegree();
        int size = FastMath.max((int)0, (int)(degree * (degree + 1) / 2 - 1));
        this.gnmOj = new double[size];
        this.hnmOj = new double[size];
        this.enm = new double[size];
        int index = 0;
        for (m = degree; m >= 0; --m) {
            int j = m == 0 ? 2 : 1;
            for (int n = FastMath.max((int)2, (int)(m + 1)); n <= degree; ++n) {
                double f = (n - m) * (n + m + 1);
                this.gnmOj[index] = (double)(2 * (m + 1)) / FastMath.sqrt((double)((double)j * f));
                this.hnmOj[index] = FastMath.sqrt((double)((double)((n + m + 2) * (n - m - 1)) / ((double)j * f)));
                this.enm[index] = FastMath.sqrt((double)(f / (double)j));
                ++index;
            }
        }
        this.sectorial = new double[degree + 1];
        this.sectorial[0] = FastMath.scalb((double)1.0, (int)-930);
        this.sectorial[1] = FastMath.sqrt((double)3.0) * this.sectorial[0];
        for (m = 2; m < this.sectorial.length; ++m) {
            this.sectorial[m] = FastMath.sqrt((double)((double)(2 * m + 1) / (2.0 * (double)m))) * this.sectorial[m - 1];
        }
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    public double value(AbsoluteDate date, Vector3D position) throws OrekitException {
        return this.mu / position.getNorm() + this.nonCentralPart(date, position);
    }

    public double nonCentralPart(AbsoluteDate date, Vector3D position) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho = FastMath.sqrt((double)(x2 + y2));
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, null, null);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    sumDegreeS += pnm0[n] * aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    sumDegreeC += pnm0[n] * aOrN[n] * harmonics.getNormalizedCnm(n, m);
                }
                value = value * u + cosSinLambda[1][m] * sumDegreeS + cosSinLambda[0][m] * sumDegreeC;
            }
            double[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = FastMath.scalb((double)value, (int)930);
        return this.mu * value / r;
    }

    public double[] gradient(AbsoluteDate date, Vector3D position) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double[] pnm1 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho2 = x2 + y2;
        double rho = FastMath.sqrt((double)rho2);
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        double[] gradient = new double[3];
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, null, pnm0, pnm1, null);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                double dSumDegreeSdR = 0.0;
                double dSumDegreeCdR = 0.0;
                double dSumDegreeSdTheta = 0.0;
                double dSumDegreeCdTheta = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    double qSnm = aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    double qCnm = aOrN[n] * harmonics.getNormalizedCnm(n, m);
                    double nOr = (double)n / r;
                    double s0 = pnm0[n] * qSnm;
                    double c0 = pnm0[n] * qCnm;
                    double s1 = pnm1[n] * qSnm;
                    double c1 = pnm1[n] * qCnm;
                    sumDegreeS += s0;
                    sumDegreeC += c0;
                    dSumDegreeSdR -= nOr * s0;
                    dSumDegreeCdR -= nOr * c0;
                    dSumDegreeSdTheta += s1;
                    dSumDegreeCdTheta += c1;
                }
                double sML = cosSinLambda[1][m];
                double cML = cosSinLambda[0][m];
                value = value * u + sML * sumDegreeS + cML * sumDegreeC;
                gradient[0] = gradient[0] * u + sML * dSumDegreeSdR + cML * dSumDegreeCdR;
                gradient[1] = gradient[1] * u + (double)m * (cML * sumDegreeS - sML * sumDegreeC);
                gradient[2] = gradient[2] * u + sML * dSumDegreeSdTheta + cML * dSumDegreeCdTheta;
            }
            double[] tmp = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp;
        }
        value = FastMath.scalb((double)value, (int)930);
        gradient[0] = FastMath.scalb((double)gradient[0], (int)930);
        gradient[1] = FastMath.scalb((double)gradient[1], (int)930);
        gradient[2] = FastMath.scalb((double)gradient[2], (int)930);
        double muOr = this.mu / r;
        gradient[0] = muOr * gradient[0] - (value *= muOr) / r;
        gradient[1] = gradient[1] * muOr;
        gradient[2] = gradient[2] * muOr;
        return new SphericalCoordinates(position).toCartesianGradient(gradient);
    }

    public GradientHessian gradientHessian(AbsoluteDate date, Vector3D position) throws OrekitException {
        int degree = this.provider.getMaxDegree();
        int order = this.provider.getMaxOrder();
        NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double[] pnm0Plus2 = new double[degree + 1];
        double[] pnm0Plus1 = new double[degree + 1];
        double[] pnm0 = new double[degree + 1];
        double[] pnm1Plus1 = new double[degree + 1];
        double[] pnm1 = new double[degree + 1];
        double[] pnm2 = new double[degree + 1];
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        double x2 = x * x;
        double y2 = y * y;
        double z2 = z * z;
        double r2 = x2 + y2 + z2;
        double r = FastMath.sqrt((double)r2);
        double rho2 = x2 + y2;
        double rho = FastMath.sqrt((double)rho2);
        double t = z / r;
        double u = rho / r;
        double tOu = z / rho;
        double[] aOrN = this.createDistancePowersArray(this.provider.getAe() / r);
        double[][] cosSinLambda = this.createCosSinArrays(position.getX() / rho, position.getY() / rho);
        int index = 0;
        double value = 0.0;
        double[] gradient = new double[3];
        double[][] hessian = new double[3][3];
        for (int m = degree; m >= 0; --m) {
            index = this.computeTesseral(m, degree, index, t, u, tOu, pnm0Plus2, pnm0Plus1, pnm1Plus1, pnm0, pnm1, pnm2);
            if (m <= order) {
                double sumDegreeS = 0.0;
                double sumDegreeC = 0.0;
                double dSumDegreeSdR = 0.0;
                double dSumDegreeCdR = 0.0;
                double dSumDegreeSdTheta = 0.0;
                double dSumDegreeCdTheta = 0.0;
                double d2SumDegreeSdRdR = 0.0;
                double d2SumDegreeSdRdTheta = 0.0;
                double d2SumDegreeSdThetadTheta = 0.0;
                double d2SumDegreeCdRdR = 0.0;
                double d2SumDegreeCdRdTheta = 0.0;
                double d2SumDegreeCdThetadTheta = 0.0;
                for (int n = FastMath.max((int)2, (int)m); n <= degree; ++n) {
                    double qSnm = aOrN[n] * harmonics.getNormalizedSnm(n, m);
                    double qCnm = aOrN[n] * harmonics.getNormalizedCnm(n, m);
                    double nOr = (double)n / r;
                    double nnP1Or2 = nOr * (double)(n + 1) / r;
                    double s0 = pnm0[n] * qSnm;
                    double c0 = pnm0[n] * qCnm;
                    double s1 = pnm1[n] * qSnm;
                    double c1 = pnm1[n] * qCnm;
                    double s2 = pnm2[n] * qSnm;
                    double c2 = pnm2[n] * qCnm;
                    sumDegreeS += s0;
                    sumDegreeC += c0;
                    dSumDegreeSdR -= nOr * s0;
                    dSumDegreeCdR -= nOr * c0;
                    dSumDegreeSdTheta += s1;
                    dSumDegreeCdTheta += c1;
                    d2SumDegreeSdRdR += nnP1Or2 * s0;
                    d2SumDegreeSdRdTheta -= nOr * s1;
                    d2SumDegreeSdThetadTheta += s2;
                    d2SumDegreeCdRdR += nnP1Or2 * c0;
                    d2SumDegreeCdRdTheta -= nOr * c1;
                    d2SumDegreeCdThetadTheta += c2;
                }
                double sML = cosSinLambda[1][m];
                double cML = cosSinLambda[0][m];
                value = value * u + sML * sumDegreeS + cML * sumDegreeC;
                gradient[0] = gradient[0] * u + sML * dSumDegreeSdR + cML * dSumDegreeCdR;
                gradient[1] = gradient[1] * u + (double)m * (cML * sumDegreeS - sML * sumDegreeC);
                gradient[2] = gradient[2] * u + sML * dSumDegreeSdTheta + cML * dSumDegreeCdTheta;
                hessian[0][0] = hessian[0][0] * u + sML * d2SumDegreeSdRdR + cML * d2SumDegreeCdRdR;
                hessian[1][0] = hessian[1][0] * u + (double)m * (cML * dSumDegreeSdR - sML * dSumDegreeCdR);
                hessian[2][0] = hessian[2][0] * u + sML * d2SumDegreeSdRdTheta + cML * d2SumDegreeCdRdTheta;
                hessian[1][1] = hessian[1][1] * u - (double)(m * m) * (sML * sumDegreeS + cML * sumDegreeC);
                hessian[2][1] = hessian[2][1] * u + (double)m * (cML * dSumDegreeSdTheta - sML * dSumDegreeCdTheta);
                hessian[2][2] = hessian[2][2] * u + sML * d2SumDegreeSdThetadTheta + cML * d2SumDegreeCdThetadTheta;
            }
            double[] tmp0 = pnm0Plus2;
            pnm0Plus2 = pnm0Plus1;
            pnm0Plus1 = pnm0;
            pnm0 = tmp0;
            double[] tmp1 = pnm1Plus1;
            pnm1Plus1 = pnm1;
            pnm1 = tmp1;
        }
        value = FastMath.scalb((double)value, (int)930);
        for (int i = 0; i < 3; ++i) {
            gradient[i] = FastMath.scalb((double)gradient[i], (int)930);
            for (int j = 0; j <= i; ++j) {
                hessian[i][j] = FastMath.scalb((double)hessian[i][j], (int)930);
            }
        }
        double muOr = this.mu / r;
        gradient[0] = muOr * gradient[0] - (value *= muOr) / r;
        gradient[1] = gradient[1] * muOr;
        gradient[2] = gradient[2] * muOr;
        hessian[0][0] = muOr * hessian[0][0] - 2.0 * gradient[0] / r;
        hessian[1][0] = muOr * hessian[1][0] - gradient[1] / r;
        hessian[2][0] = muOr * hessian[2][0] - gradient[2] / r;
        double[] dArray = hessian[1];
        dArray[1] = dArray[1] * muOr;
        double[] dArray2 = hessian[2];
        dArray2[1] = dArray2[1] * muOr;
        double[] dArray3 = hessian[2];
        dArray3[2] = dArray3[2] * muOr;
        SphericalCoordinates sc = new SphericalCoordinates(position);
        return new GradientHessian(sc.toCartesianGradient(gradient), sc.toCartesianHessian(hessian, gradient));
    }

    private double[] createDistancePowersArray(double aOr) {
        double[] aOrN = new double[this.provider.getMaxDegree() + 1];
        aOrN[0] = 1.0;
        aOrN[1] = aOr;
        for (int n = 2; n < aOrN.length; ++n) {
            int p = n / 2;
            int q = n - p;
            aOrN[n] = aOrN[p] * aOrN[q];
        }
        return aOrN;
    }

    private double[][] createCosSinArrays(double cosLambda, double sinLambda) {
        double[][] cosSin = new double[2][this.provider.getMaxOrder() + 1];
        cosSin[0][0] = 1.0;
        cosSin[1][0] = 0.0;
        if (this.provider.getMaxOrder() > 0) {
            cosSin[0][1] = cosLambda;
            cosSin[1][1] = sinLambda;
            for (int m = 2; m < cosSin[0].length; ++m) {
                int p = m / 2;
                int q = m - p;
                cosSin[0][m] = cosSin[0][p] * cosSin[0][q] - cosSin[1][p] * cosSin[1][q];
                cosSin[1][m] = cosSin[1][p] * cosSin[0][q] + cosSin[0][p] * cosSin[1][q];
            }
        }
        return cosSin;
    }

    private int computeTesseral(int m, int degree, int index, double t, double u, double tOu, double[] pnm0Plus2, double[] pnm0Plus1, double[] pnm1Plus1, double[] pnm0, double[] pnm1, double[] pnm2) {
        double u2 = u * u;
        int n = FastMath.max((int)2, (int)m);
        if (n == m) {
            pnm0[n] = this.sectorial[n];
            ++n;
        }
        int localIndex = index;
        while (n <= degree) {
            pnm0[n] = this.gnmOj[localIndex] * t * pnm0Plus1[n] - this.hnmOj[localIndex] * u2 * pnm0Plus2[n];
            ++localIndex;
            ++n;
        }
        if (pnm1 != null) {
            n = FastMath.max((int)2, (int)m);
            if (n == m) {
                pnm1[n] = (double)m * tOu * pnm0[n];
                ++n;
            }
            localIndex = index;
            while (n <= degree) {
                pnm1[n] = (double)m * tOu * pnm0[n] - this.enm[localIndex] * u * pnm0Plus1[n];
                ++localIndex;
                ++n;
            }
            if (pnm2 != null) {
                n = FastMath.max((int)2, (int)m);
                if (n == m) {
                    pnm2[n] = (double)m * (tOu * pnm1[n] - pnm0[n] / u2);
                    ++n;
                }
                localIndex = index;
                while (n <= degree) {
                    pnm2[n] = (double)m * (tOu * pnm1[n] - pnm0[n] / u2) - this.enm[localIndex] * u * pnm1Plus1[n];
                    ++localIndex;
                    ++n;
                }
            }
        }
        return localIndex;
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        AbsoluteDate date = s.getDate();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D position = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        Vector3D gInertial = fromBodyFrame.transformVector(new Vector3D(this.gradient(date, position)));
        adder.addXYZAcceleration(gInertial.getX(), gInertial.getY(), gInertial.getZ());
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[0];
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.mu;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.mu = value;
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(frame, date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D positionBody = toBodyFrame.transformPosition(position.toVector3D());
        GradientHessian gh = this.gradientHessian(date, positionBody);
        double[] gInertial = fromBodyFrame.transformVector(new Vector3D(gh.getGradient())).toArray();
        Array2DRowRealMatrix hBody = new Array2DRowRealMatrix(gh.getHessian(), false);
        Array2DRowRealMatrix rot = new Array2DRowRealMatrix(toBodyFrame.getRotation().getMatrix());
        RealMatrix hInertial = rot.transpose().multiply((RealMatrix)hBody).multiply((RealMatrix)rot);
        int parameters = mass.getFreeParameters();
        int order = mass.getOrder();
        double[] derivatives = new double[1 + parameters];
        DerivativeStructure[] accDer = new DerivativeStructure[3];
        for (int i = 0; i < 3; ++i) {
            derivatives[0] = gInertial[i];
            derivatives[1] = hInertial.getEntry(i, 0);
            derivatives[2] = hInertial.getEntry(i, 1);
            derivatives[3] = hInertial.getEntry(i, 2);
            accDer[i] = new DerivativeStructure(parameters, order, derivatives);
        }
        return new FieldVector3D((RealFieldElement[])accDer);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException, IllegalArgumentException {
        this.complainIfNotSupported(paramName);
        AbsoluteDate date = s.getDate();
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D position = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        Vector3D gInertial = fromBodyFrame.transformVector(new Vector3D(this.gradient(date, position)));
        return new FieldVector3D((RealFieldElement)new DerivativeStructure(1, 1, new double[]{gInertial.getX(), gInertial.getX() / this.mu}), (RealFieldElement)new DerivativeStructure(1, 1, new double[]{gInertial.getY(), gInertial.getY() / this.mu}), (RealFieldElement)new DerivativeStructure(1, 1, new double[]{gInertial.getZ(), gInertial.getZ() / this.mu}));
    }

    public static class GradientHessian
    implements Serializable {
        private static final long serialVersionUID = 20130219L;
        private final double[] gradient;
        private final double[][] hessian;

        public GradientHessian(double[] gradient, double[][] hessian) {
            this.gradient = gradient;
            this.hessian = hessian;
        }

        public double[] getGradient() {
            return this.gradient;
        }

        public double[][] getHessian() {
            return this.hessian;
        }
    }
}

