/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.List;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.ode.UnknownParameterException;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.HolmesFeatherstoneAttractionModel;
import org.orekit.forces.gravity.OceanTidesField;
import org.orekit.forces.gravity.potential.CachedNormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.OrekitConfiguration;

public class OceanTides
extends AbstractParameterizable
implements ForceModel {
    public static final double DEFAULT_STEP = 600.0;
    public static final int DEFAULT_POINTS = 12;
    private final ForceModel attractionModel;

    public OceanTides(Frame centralBodyFrame, double ae, double mu, int degree, int order, IERSConventions conventions, UT1Scale ut1) throws OrekitException {
        this(centralBodyFrame, ae, mu, true, 600.0, 12, degree, order, conventions, ut1);
    }

    public OceanTides(Frame centralBodyFrame, double ae, double mu, boolean poleTide, double step, int nbPoints, int degree, int order, IERSConventions conventions, UT1Scale ut1) throws OrekitException {
        super(new String[0]);
        List<OceanTidesWave> waves = GravityFieldFactory.getOceanTidesWaves(degree, order);
        OceanTidesField raw = new OceanTidesField(ae, mu, waves, conventions.getNutationArguments(ut1), poleTide ? conventions.getOceanPoleTide(ut1.getEOPHistory()) : null);
        NormalizedSphericalHarmonicsProvider provider = nbPoints < 2 ? raw : new CachedNormalizedSphericalHarmonicsProvider(raw, step, nbPoints, OrekitConfiguration.getCacheSlotsNumber(), 604800.0, 43200.0);
        this.attractionModel = new HolmesFeatherstoneAttractionModel(centralBodyFrame, provider);
    }

    public double getParameter(String name) throws UnknownParameterException {
        throw new UnknownParameterException(name);
    }

    public void setParameter(String name, double value) throws UnknownParameterException {
        throw new UnknownParameterException(name);
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        this.attractionModel.addContribution(s, adder);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        return this.attractionModel.accelerationDerivatives(date, frame, position, velocity, rotation, mass);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        return this.attractionModel.accelerationDerivatives(s, paramName);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return this.attractionModel.getEventsDetectors();
    }
}

