/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;

public class ThirdBodyAttraction
extends AbstractParameterizable
implements ForceModel {
    public static final String ATTRACTION_COEFFICIENT_SUFFIX = " attraction coefficient";
    private final CelestialBody body;
    private double gm;

    public ThirdBodyAttraction(CelestialBody body) {
        super(new String[]{body.getName() + ATTRACTION_COEFFICIENT_SUFFIX});
        this.body = body;
        this.gm = body.getGM();
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        Vector3D centralToBody = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        double r2Central = centralToBody.getNormSq();
        Vector3D satToBody = centralToBody.subtract((Vector)s.getPVCoordinates().getPosition());
        double r2Sat = satToBody.getNormSq();
        Vector3D gamma = new Vector3D(this.gm / (r2Sat * FastMath.sqrt((double)r2Sat)), satToBody, -this.gm / (r2Central * FastMath.sqrt((double)r2Central)), centralToBody);
        adder.addXYZAcceleration(gamma.getX(), gamma.getY(), gamma.getZ());
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        Vector3D centralToBody = this.body.getPVCoordinates(date, frame).getPosition();
        double r2Central = centralToBody.getNormSq();
        FieldVector3D satToBody = position.subtract(centralToBody).negate();
        DerivativeStructure r2Sat = (DerivativeStructure)satToBody.getNormSq();
        FieldVector3D satAcc = new FieldVector3D((RealFieldElement)r2Sat.sqrt().multiply(r2Sat).reciprocal().multiply(this.gm), satToBody);
        Vector3D centralAcc = new Vector3D(this.gm / (r2Central * FastMath.sqrt((double)r2Central)), centralToBody);
        return satAcc.subtract(centralAcc);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        this.complainIfNotSupported(paramName);
        Vector3D centralToBody = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        double r2Central = centralToBody.getNormSq();
        Vector3D satToBody = centralToBody.subtract((Vector)s.getPVCoordinates().getPosition());
        double r2Sat = satToBody.getNormSq();
        DerivativeStructure gmds = new DerivativeStructure(1, 1, 0, this.gm);
        return new FieldVector3D((RealFieldElement)gmds.divide(r2Sat * FastMath.sqrt((double)r2Sat)), satToBody, (RealFieldElement)gmds.divide(-r2Central * FastMath.sqrt((double)r2Central)), centralToBody);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[0];
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.gm;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.gm = value;
    }
}

