/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

class ConstantSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final double ae;
    private final double mu;
    private final TideSystem tideSystem;
    private final double[][] rawC;
    private final double[][] rawS;

    public ConstantSphericalHarmonics(double ae, double mu, TideSystem tideSystem, double[][] rawC, double[][] rawS) {
        this.ae = ae;
        this.mu = mu;
        this.tideSystem = tideSystem;
        this.rawC = rawC;
        this.rawS = rawS;
    }

    @Override
    public int getMaxDegree() {
        return this.rawC.length - 1;
    }

    @Override
    public int getMaxOrder() {
        return this.rawC[this.rawC.length - 1].length - 1;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public double getAe() {
        return this.ae;
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return null;
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return 0.0;
    }

    @Override
    public TideSystem getTideSystem() {
        return this.tideSystem;
    }

    @Override
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) {
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) throws OrekitException {
                ConstantSphericalHarmonics.this.checkLimits(n, m);
                return ConstantSphericalHarmonics.this.rawC[n][m];
            }

            @Override
            public double getRawSnm(int n, int m) throws OrekitException {
                ConstantSphericalHarmonics.this.checkLimits(n, m);
                return ConstantSphericalHarmonics.this.rawS[n][m];
            }
        };
    }

    private void checkLimits(int degree, int order) throws OrekitException {
        if (degree >= this.rawC.length) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_DEGREE_FOR_GRAVITY_FIELD, degree, this.rawC.length - 1);
        }
        if (order >= this.rawC[degree].length) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ORDER_FOR_GRAVITY_FIELD, order, this.rawC[degree].length - 1);
        }
    }
}

