/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

class WrappingNormalizedProvider
implements NormalizedSphericalHarmonicsProvider {
    private final RawSphericalHarmonicsProvider rawProvider;

    public WrappingNormalizedProvider(RawSphericalHarmonicsProvider rawProvider) {
        this.rawProvider = rawProvider;
    }

    @Override
    public int getMaxDegree() {
        return this.rawProvider.getMaxDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.rawProvider.getMaxOrder();
    }

    @Override
    public double getMu() {
        return this.rawProvider.getMu();
    }

    @Override
    public double getAe() {
        return this.rawProvider.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.rawProvider.getReferenceDate();
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return this.rawProvider.getOffset(date);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.rawProvider.getTideSystem();
    }

    @Override
    public NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics onDate(final AbsoluteDate date) throws OrekitException {
        final RawSphericalHarmonicsProvider.RawSphericalHarmonics raw = this.rawProvider.onDate(date);
        return new NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getNormalizedCnm(int n, int m) throws OrekitException {
                return raw.getRawCnm(n, m);
            }

            @Override
            public double getNormalizedSnm(int n, int m) throws OrekitException {
                return raw.getRawSnm(n, m);
            }
        };
    }
}

