/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import java.util.Arrays;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AdapterPropagator;
import org.orekit.time.AbsoluteDate;

public class SmallManeuverAnalyticalModel
implements AdapterPropagator.DifferentialEffect {
    private final SpacecraftState state0;
    private final Vector3D inertialDV;
    private final double massRatio;
    private final OrbitType type;
    private final double[][] j0;
    private double[][] j0Dot;
    private final double ksi;

    public SmallManeuverAnalyticalModel(SpacecraftState state0, Vector3D dV, double isp) throws OrekitException {
        this(state0, state0.getFrame(), state0.getAttitude().getRotation().applyInverseTo(dV), isp);
    }

    public SmallManeuverAnalyticalModel(SpacecraftState state0, Frame frame, Vector3D dV, double isp) throws OrekitException {
        this.state0 = state0;
        this.massRatio = FastMath.exp((double)(-dV.getNorm() / (9.80665 * isp)));
        this.type = state0.getE() < 0.9 ? OrbitType.EQUINOCTIAL : OrbitType.KEPLERIAN;
        double[][] fullJacobian = new double[6][6];
        this.j0 = new double[6][3];
        Orbit orbit0 = this.type.convertType(state0.getOrbit());
        orbit0.getJacobianWrtCartesian(PositionAngle.MEAN, fullJacobian);
        for (int i = 0; i < this.j0.length; ++i) {
            System.arraycopy(fullJacobian[i], 3, this.j0[i], 0, 3);
        }
        this.j0Dot = null;
        this.inertialDV = frame.getTransformTo(state0.getFrame(), state0.getDate()).transformVector(dV);
        double mu = state0.getMu();
        double a = state0.getA();
        this.ksi = -1.5 * FastMath.sqrt((double)(mu / a)) / (a * a);
    }

    public AbsoluteDate getDate() {
        return this.state0.getDate();
    }

    public Vector3D getInertialDV() {
        return this.inertialDV;
    }

    public Frame getInertialFrame() {
        return this.state0.getFrame();
    }

    public Orbit apply(Orbit orbit1) {
        if (orbit1.getDate().compareTo(this.state0.getDate()) <= 0) {
            return orbit1;
        }
        return this.updateOrbit(orbit1);
    }

    @Override
    public SpacecraftState apply(SpacecraftState state1) {
        if (state1.getDate().compareTo(this.state0.getDate()) <= 0) {
            return state1;
        }
        return new SpacecraftState(this.updateOrbit(state1.getOrbit()), state1.getAttitude(), this.updateMass(state1.getMass()));
    }

    private Orbit updateOrbit(Orbit orbit1) {
        double dt = orbit1.getDate().durationFrom(this.state0.getDate());
        double x = this.inertialDV.getX();
        double y = this.inertialDV.getY();
        double z = this.inertialDV.getZ();
        double[] delta = new double[6];
        for (int i = 0; i < delta.length; ++i) {
            delta[i] = this.j0[i][0] * x + this.j0[i][1] * y + this.j0[i][2] * z;
        }
        delta[5] = delta[5] + this.ksi * delta[0] * dt;
        double[] parameters = new double[6];
        this.type.mapOrbitToArray(this.type.convertType(orbit1), PositionAngle.MEAN, parameters);
        for (int i = 0; i < delta.length; ++i) {
            int n = i;
            parameters[n] = parameters[n] + delta[i];
        }
        Orbit o = this.type.mapArrayToOrbit(parameters, PositionAngle.MEAN, orbit1.getDate(), orbit1.getMu(), orbit1.getFrame());
        return orbit1.getType().convertType(o);
    }

    public void getJacobian(Orbit orbit1, PositionAngle positionAngle, double[][] jacobian) throws OrekitException {
        int i;
        double dt = orbit1.getDate().durationFrom(this.state0.getDate());
        if (dt < 0.0) {
            for (int i2 = 0; i2 < 6; ++i2) {
                Arrays.fill(jacobian[i2], 0, 4, 0.0);
            }
            return;
        }
        double x = this.inertialDV.getX();
        double y = this.inertialDV.getY();
        double z = this.inertialDV.getZ();
        for (i = 0; i < 6; ++i) {
            System.arraycopy(this.j0[i], 0, jacobian[i], 0, 3);
        }
        for (int j = 0; j < 3; ++j) {
            double[] dArray = jacobian[5];
            int n = j;
            dArray[n] = dArray[n] + this.ksi * dt * this.j0[0][j];
        }
        this.evaluateJ0Dot();
        for (i = 0; i < 6; ++i) {
            jacobian[i][3] = this.j0Dot[i][0] * x + this.j0Dot[i][1] * y + this.j0Dot[i][2] * z;
        }
        double da = this.j0[0][0] * x + this.j0[0][1] * y + this.j0[0][2] * z;
        double[] dArray = jacobian[5];
        dArray[3] = dArray[3] + this.ksi * (jacobian[0][3] * dt - da);
        if (orbit1.getType() != this.type || positionAngle != PositionAngle.MEAN) {
            int j;
            double[][] j2 = new double[6][6];
            double[][] pvJacobian = new double[6][4];
            Orbit updated = this.updateOrbit(orbit1);
            this.type.convertType(updated).getJacobianWrtParameters(PositionAngle.MEAN, j2);
            for (int i3 = 0; i3 < 6; ++i3) {
                for (j = 0; j < 4; ++j) {
                    pvJacobian[i3][j] = j2[i3][0] * jacobian[0][j] + j2[i3][1] * jacobian[1][j] + j2[i3][2] * jacobian[2][j] + j2[i3][3] * jacobian[3][j] + j2[i3][4] * jacobian[4][j] + j2[i3][5] * jacobian[5][j];
                }
            }
            double[][] j3 = new double[6][6];
            updated.getJacobianWrtCartesian(positionAngle, j3);
            for (j = 0; j < 4; ++j) {
                for (int i4 = 0; i4 < 6; ++i4) {
                    jacobian[i4][j] = j3[i4][0] * pvJacobian[0][j] + j3[i4][1] * pvJacobian[1][j] + j3[i4][2] * pvJacobian[2][j] + j3[i4][3] * pvJacobian[3][j] + j3[i4][4] * pvJacobian[4][j] + j3[i4][5] * pvJacobian[5][j];
                }
            }
        }
    }

    private void evaluateJ0Dot() throws OrekitException {
        if (this.j0Dot == null) {
            this.j0Dot = new double[6][3];
            double dt = 1.0E-5 / this.state0.getKeplerianMeanMotion();
            Orbit orbit = this.type.convertType(this.state0.getOrbit());
            double[][] j0m1 = new double[6][6];
            orbit.shiftedBy(-1.0 * dt).getJacobianWrtCartesian(PositionAngle.MEAN, j0m1);
            double[][] j0p1 = new double[6][6];
            orbit.shiftedBy(1.0 * dt).getJacobianWrtCartesian(PositionAngle.MEAN, j0p1);
            for (int i = 0; i < this.j0Dot.length; ++i) {
                double[] m1Row = j0m1[i];
                double[] p1Row = j0p1[i];
                double[] j0DotRow = this.j0Dot[i];
                for (int j = 0; j < 3; ++j) {
                    j0DotRow[j] = (p1Row[j + 3] - m1Row[j + 3]) / (2.0 * dt);
                }
            }
        }
    }

    public double updateMass(double mass) {
        return this.massRatio * mass;
    }
}

