/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.Predefined;
import org.orekit.frames.TransformProvider;

public class FactoryManagedFrame
extends Frame {
    private static final long serialVersionUID = -8176399341069422724L;
    private final Predefined factoryKey;

    public FactoryManagedFrame(Frame parent, TransformProvider transformProvider, boolean pseudoInertial, Predefined factoryKey) {
        super(parent, transformProvider, factoryKey.getName(), pseudoInertial);
        this.factoryKey = factoryKey;
    }

    public Predefined getFactoryKey() {
        return this.factoryKey;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.factoryKey);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 2970971575793609756L;
        private final String name;

        private DataTransferObject(Predefined factoryKey) {
            this.name = factoryKey.name();
        }

        private Object readResolve() {
            try {
                return FramesFactory.getFrame(Predefined.valueOf(this.name));
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

