/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public enum LOFType {
    TNW{

        @Override
        protected Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }
    }
    ,
    QSW{

        @Override
        protected Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }
    }
    ,
    LVLH{

        @Override
        protected Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }
    }
    ,
    VVLH{

        @Override
        protected Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.MINUS_K, Vector3D.MINUS_J);
        }
    }
    ,
    VNC{

        @Override
        protected Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_J);
        }
    };


    public Transform transformFromInertial(AbsoluteDate date, PVCoordinates pv) {
        Transform translation = new Transform(date, pv.negate());
        Rotation r = this.rotationFromInertial(pv);
        Vector3D p = pv.getPosition();
        Vector3D momentum = pv.getMomentum();
        Transform rotation = new Transform(date, r, new Vector3D(1.0 / p.getNormSq(), r.applyTo(momentum)));
        return new Transform(date, translation, rotation);
    }

    protected abstract Rotation rotationFromInertial(PVCoordinates var1);
}

