/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.utils.IERSConventions;

class MODProvider
implements TransformProvider {
    private static final long serialVersionUID = 20130920L;
    private final IERSConventions conventions;
    private final transient TimeFunction<double[]> precessionFunction;
    private final Rotation r4;

    public MODProvider(IERSConventions conventions) throws OrekitException {
        this.conventions = conventions;
        this.precessionFunction = conventions.getPrecessionFunction();
        TimeFunction<Double> epsilonAFunction = conventions.getMeanObliquityFunction();
        AbsoluteDate date0 = conventions.getNutationReferenceEpoch();
        double epsilon0 = epsilonAFunction.value(date0);
        this.r4 = new Rotation(Vector3D.PLUS_I, -epsilon0);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double[] angles = this.precessionFunction.value(date);
        Rotation r1 = new Rotation(Vector3D.PLUS_K, -angles[2]);
        Rotation r2 = new Rotation(Vector3D.PLUS_I, angles[1]);
        Rotation r3 = new Rotation(Vector3D.PLUS_K, angles[0]);
        Rotation precession = r1.applyTo(r2.applyTo(r3.applyTo(this.r4)));
        return new Transform(date, precession);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;

        public DataTransferObject(IERSConventions conventions) {
            this.conventions = conventions;
        }

        private Object readResolve() {
            try {
                return new MODProvider(this.conventions);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

