/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UT1Scale;

class TIRFProvider
implements TransformProvider {
    private static final long serialVersionUID = 20130919L;
    private static final double AVE = 7.292115146706979E-5;
    private final EOPHistory eopHistory;
    private final transient TimeFunction<DerivativeStructure> era;

    protected TIRFProvider(EOPHistory eopHistory) throws OrekitException {
        UT1Scale ut1 = TimeScalesFactory.getUT1(eopHistory);
        this.eopHistory = eopHistory;
        this.era = eopHistory.getConventions().getEarthOrientationAngleFunction(ut1);
    }

    EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double correctedERA = this.era.value(date).getValue();
        double lod = this.eopHistory == null ? 0.0 : this.eopHistory.getLOD(date);
        double omp = 7.292115146706979E-5 * (1.0 - lod / 86400.0);
        Vector3D rotationRate = new Vector3D(omp, Vector3D.PLUS_K);
        Rotation rotation = new Rotation(Vector3D.PLUS_K, -correctedERA);
        return new Transform(date, rotation, rotationRate);
    }

    public double getEarthRotationAngle(AbsoluteDate date) throws OrekitException {
        return MathUtils.normalizeAngle((double)this.era.value(date).getValue(), (double)0.0);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final EOPHistory eopHistory;

        public DataTransferObject(EOPHistory eopHistory) {
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TIRFProvider(this.eopHistory);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

