/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.exception.util.ExceptionContextProvider;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TopocentricFrame
extends Frame
implements PVCoordinatesProvider {
    private static final long serialVersionUID = -5997915708080966466L;
    private final BodyShape parentShape;
    private final GeodeticPoint point;

    public TopocentricFrame(BodyShape parentShape, GeodeticPoint point, String name) {
        super(parentShape.getBodyFrame(), new Transform(AbsoluteDate.J2000_EPOCH, new Transform(AbsoluteDate.J2000_EPOCH, parentShape.transform(point).negate()), new Transform(AbsoluteDate.J2000_EPOCH, new Rotation(point.getEast(), point.getZenith(), Vector3D.PLUS_I, Vector3D.PLUS_K), Vector3D.ZERO)), name, false);
        this.parentShape = parentShape;
        this.point = point;
    }

    public BodyShape getParentShape() {
        return this.parentShape;
    }

    public GeodeticPoint getPoint() {
        return this.point;
    }

    public Vector3D getZenith() {
        return this.point.getZenith();
    }

    public Vector3D getNadir() {
        return this.point.getNadir();
    }

    public Vector3D getNorth() {
        return this.point.getNorth();
    }

    public Vector3D getSouth() {
        return this.point.getSouth();
    }

    public Vector3D getEast() {
        return this.point.getEast();
    }

    public Vector3D getWest() {
        return this.point.getWest();
    }

    public double getElevation(Vector3D extPoint, Frame frame, AbsoluteDate date) throws OrekitException {
        Transform t = frame.getTransformTo(this, date);
        Vector3D extPointTopo = t.transformPosition(extPoint);
        return extPointTopo.getDelta();
    }

    public double getAzimuth(Vector3D extPoint, Frame frame, AbsoluteDate date) throws OrekitException {
        Transform t = this.getTransformTo(frame, date).getInverse();
        Vector3D extPointTopo = t.transformPosition(extPoint);
        double azimuth = FastMath.atan2((double)extPointTopo.getX(), (double)extPointTopo.getY());
        if (azimuth < 0.0) {
            azimuth += Math.PI * 2;
        }
        return azimuth;
    }

    public double getRange(Vector3D extPoint, Frame frame, AbsoluteDate date) throws OrekitException {
        Transform t = frame.getTransformTo(this, date);
        Vector3D extPointTopo = t.transformPosition(extPoint);
        return extPointTopo.getNorm();
    }

    public double getRangeRate(PVCoordinates extPV, Frame frame, AbsoluteDate date) throws OrekitException {
        Transform t = frame.getTransformTo(this, date);
        PVCoordinates extPVTopo = t.transformPVCoordinates(extPV);
        return Vector3D.dotProduct((Vector3D)extPVTopo.getPosition(), (Vector3D)extPVTopo.getVelocity()) / extPVTopo.getPosition().getNorm();
    }

    public GeodeticPoint computeLimitVisibilityPoint(final double radius, final double azimuth, final double elevation) throws OrekitException {
        try {
            double deltaP = 0.001;
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.567855942887398E-10, 0.001, 0.001, 5);
            double distance = solver.solve(1000, new UnivariateFunction(){

                public double value(double x) {
                    try {
                        GeodeticPoint gp = TopocentricFrame.this.pointAtDistance(azimuth, elevation, x);
                        return TopocentricFrame.this.parentShape.transform(gp).getNorm() - radius;
                    }
                    catch (OrekitException oe) {
                        throw new OrekitExceptionWrapper(oe);
                    }
                }
            }, 0.0, 2.0 * radius);
            return this.pointAtDistance(azimuth, elevation, distance);
        }
        catch (TooManyEvaluationsException tmee) {
            throw new OrekitException((ExceptionContextProvider)tmee);
        }
        catch (OrekitExceptionWrapper lwe) {
            throw lwe.getException();
        }
    }

    public GeodeticPoint pointAtDistance(double azimuth, double elevation, double distance) throws OrekitException {
        double cosAz = FastMath.cos((double)azimuth);
        double sinAz = FastMath.sin((double)azimuth);
        double cosEl = FastMath.cos((double)elevation);
        double sinEl = FastMath.sin((double)elevation);
        Vector3D observed = new Vector3D(distance * cosEl * sinAz, distance * cosEl * cosAz, distance * sinEl);
        return this.parentShape.transform(observed, this, AbsoluteDate.J2000_EPOCH);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
        return this.getTransformTo(frame, date).transformPVCoordinates(new TimeStampedPVCoordinates(date, Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO));
    }
}

