/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.errors.FrameAncestorException;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;

public class UpdatableFrame
extends Frame {
    private static final long serialVersionUID = -2075893064211339303L;

    public UpdatableFrame(Frame parent, Transform transform, String name) throws IllegalArgumentException {
        this(parent, transform, name, false);
    }

    public UpdatableFrame(Frame parent, Transform transform, String name, boolean pseudoInertial) throws IllegalArgumentException {
        super(parent, new UpdatableProvider(transform), name, pseudoInertial);
    }

    public void updateTransform(Frame f1, Frame f2, Transform f1Tof2, AbsoluteDate date) throws OrekitException {
        Frame fA = f1;
        Frame fB = f2;
        Transform fAtoB = f1Tof2;
        if (fA.isChildOf(this) || fA == this) {
            if (fB.isChildOf(this) || fB == this) {
                throw new FrameAncestorException((Localizable)OrekitMessages.FRAME_ANCESTOR_OF_BOTH_FRAMES, this.getName(), fA.getName(), fB.getName());
            }
            Frame tmp = fA;
            fA = fB;
            fB = tmp;
            fAtoB = fAtoB.getInverse();
        } else if (!fB.isChildOf(this) && fB != this) {
            throw new FrameAncestorException((Localizable)OrekitMessages.FRAME_ANCESTOR_OF_NEITHER_FRAME, this.getName(), fA.getName(), fB.getName());
        }
        Transform parentTofA = this.getParent().getTransformTo(fA, date);
        Transform fBtoSelf = fB.getTransformTo(this, date);
        Transform fAtoSelf = new Transform(date, fAtoB, fBtoSelf);
        Transform parentToSelf = new Transform(date, parentTofA, fAtoSelf);
        ((UpdatableProvider)this.getTransformProvider()).setTransform(parentToSelf);
    }

    private static class UpdatableProvider
    implements TransformProvider {
        private static final long serialVersionUID = 4436954500689776331L;
        private AtomicReference<Transform> transform;

        public UpdatableProvider(Transform transform) {
            this.transform = new AtomicReference<Transform>(transform);
        }

        public void setTransform(Transform transform) {
            this.transform.set(transform);
        }

        @Override
        public Transform getTransform(AbsoluteDate date) {
            return this.transform.get();
        }
    }
}

