/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class Orbit
implements TimeStamped,
TimeShiftable<Orbit>,
TimeInterpolable<Orbit>,
Serializable,
PVCoordinatesProvider {
    private static final long serialVersionUID = 438733454597999578L;
    private final Frame frame;
    private final AbsoluteDate date;
    private final double mu;
    private transient TimeStampedPVCoordinates pvCoordinates;
    private transient double[][] jacobianMeanWrtCartesian;
    private transient double[][] jacobianWrtParametersMean;
    private transient double[][] jacobianEccentricWrtCartesian;
    private transient double[][] jacobianWrtParametersEccentric;
    private transient double[][] jacobianTrueWrtCartesian;
    private transient double[][] jacobianWrtParametersTrue;

    protected Orbit(Frame frame, AbsoluteDate date, double mu) throws IllegalArgumentException {
        Orbit.ensurePseudoInertialFrame(frame);
        this.date = date;
        this.mu = mu;
        this.pvCoordinates = null;
        this.frame = frame;
        this.jacobianMeanWrtCartesian = null;
        this.jacobianWrtParametersMean = null;
        this.jacobianEccentricWrtCartesian = null;
        this.jacobianWrtParametersEccentric = null;
        this.jacobianTrueWrtCartesian = null;
        this.jacobianWrtParametersTrue = null;
    }

    protected Orbit(TimeStampedPVCoordinates pvCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        Orbit.ensurePseudoInertialFrame(frame);
        this.date = pvCoordinates.getDate();
        this.mu = mu;
        if (pvCoordinates.getAcceleration().getNormSq() == 0.0) {
            double r2 = pvCoordinates.getPosition().getNormSq();
            double r3 = r2 * FastMath.sqrt((double)r2);
            this.pvCoordinates = new TimeStampedPVCoordinates(pvCoordinates.getDate(), pvCoordinates.getPosition(), pvCoordinates.getVelocity(), new Vector3D(-mu / r3, pvCoordinates.getPosition()));
        } else {
            this.pvCoordinates = pvCoordinates;
        }
        this.frame = frame;
    }

    public abstract OrbitType getType();

    private static void ensurePseudoInertialFrame(Frame frame) throws IllegalArgumentException {
        if (!frame.isPseudoInertial()) {
            throw OrekitException.createIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME_NOT_SUITABLE_FOR_DEFINING_ORBITS, frame.getName());
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public abstract double getA();

    public abstract double getEquinoctialEx();

    public abstract double getEquinoctialEy();

    public abstract double getHx();

    public abstract double getHy();

    public abstract double getLE();

    public abstract double getLv();

    public abstract double getLM();

    public abstract double getE();

    public abstract double getI();

    public double getMu() {
        return this.mu;
    }

    public double getKeplerianPeriod() {
        double a = this.getA();
        return a < 0.0 ? Double.POSITIVE_INFINITY : Math.PI * 2 * a * FastMath.sqrt((double)(a / this.mu));
    }

    public double getKeplerianMeanMotion() {
        double absA = FastMath.abs((double)this.getA());
        return FastMath.sqrt((double)(this.mu / absA)) / absA;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public TimeStampedPVCoordinates getPVCoordinates(Frame outputFrame) throws OrekitException {
        if (this.pvCoordinates == null) {
            this.pvCoordinates = this.initPVCoordinates();
        }
        if (outputFrame == this.frame) {
            return this.pvCoordinates;
        }
        Transform t = this.frame.getTransformTo(outputFrame, this.date);
        return t.transformPVCoordinates(this.pvCoordinates);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate otherDate, Frame otherFrame) throws OrekitException {
        return this.shiftedBy(otherDate.durationFrom(this.getDate())).getPVCoordinates(otherFrame);
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        if (this.pvCoordinates == null) {
            this.pvCoordinates = this.initPVCoordinates();
        }
        return this.pvCoordinates;
    }

    protected abstract TimeStampedPVCoordinates initPVCoordinates();

    @Override
    public abstract Orbit shiftedBy(double var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJacobianWrtCartesian(PositionAngle type, double[][] jacobian) {
        double[][] cachedJacobian;
        Orbit orbit = this;
        synchronized (orbit) {
            switch (type) {
                case MEAN: {
                    if (this.jacobianMeanWrtCartesian == null) {
                        this.jacobianMeanWrtCartesian = this.computeJacobianMeanWrtCartesian();
                    }
                    cachedJacobian = this.jacobianMeanWrtCartesian;
                    break;
                }
                case ECCENTRIC: {
                    if (this.jacobianEccentricWrtCartesian == null) {
                        this.jacobianEccentricWrtCartesian = this.computeJacobianEccentricWrtCartesian();
                    }
                    cachedJacobian = this.jacobianEccentricWrtCartesian;
                    break;
                }
                case TRUE: {
                    if (this.jacobianTrueWrtCartesian == null) {
                        this.jacobianTrueWrtCartesian = this.computeJacobianTrueWrtCartesian();
                    }
                    cachedJacobian = this.jacobianTrueWrtCartesian;
                    break;
                }
                default: {
                    throw OrekitException.createInternalError(null);
                }
            }
        }
        for (int i = 0; i < cachedJacobian.length; ++i) {
            System.arraycopy(cachedJacobian[i], 0, jacobian[i], 0, cachedJacobian[i].length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJacobianWrtParameters(PositionAngle type, double[][] jacobian) {
        double[][] cachedJacobian;
        Orbit orbit = this;
        synchronized (orbit) {
            switch (type) {
                case MEAN: {
                    if (this.jacobianWrtParametersMean == null) {
                        this.jacobianWrtParametersMean = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersMean;
                    break;
                }
                case ECCENTRIC: {
                    if (this.jacobianWrtParametersEccentric == null) {
                        this.jacobianWrtParametersEccentric = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersEccentric;
                    break;
                }
                case TRUE: {
                    if (this.jacobianWrtParametersTrue == null) {
                        this.jacobianWrtParametersTrue = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersTrue;
                    break;
                }
                default: {
                    throw OrekitException.createInternalError(null);
                }
            }
        }
        for (int i = 0; i < cachedJacobian.length; ++i) {
            System.arraycopy(cachedJacobian[i], 0, jacobian[i], 0, cachedJacobian[i].length);
        }
    }

    private double[][] createInverseJacobian(PositionAngle type) {
        double[][] directJacobian = new double[6][6];
        this.getJacobianWrtCartesian(type, directJacobian);
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])directJacobian);
        DecompositionSolver solver = new QRDecomposition(matrix).getSolver();
        return solver.getInverse().getData();
    }

    protected abstract double[][] computeJacobianMeanWrtCartesian();

    protected abstract double[][] computeJacobianEccentricWrtCartesian();

    protected abstract double[][] computeJacobianTrueWrtCartesian();

    public abstract void addKeplerContribution(PositionAngle var1, double var2, double[] var4);

    protected static void fillHalfRow(double a, Vector3D v, double[] row, int j) {
        row[j] = a * v.getX();
        row[j + 1] = a * v.getY();
        row[j + 2] = a * v.getZ();
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double[] row, int j) {
        row[j] = a1 * v1.getX() + a2 * v2.getX();
        row[j + 1] = a1 * v1.getY() + a2 * v2.getY();
        row[j + 2] = a1 * v1.getZ() + a2 * v2.getZ();
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double[] row, int j) {
        row[j] = a1 * v1.getX() + a2 * v2.getX() + a3 * v3.getX();
        row[j + 1] = a1 * v1.getY() + a2 * v2.getY() + a3 * v3.getY();
        row[j + 2] = a1 * v1.getZ() + a2 * v2.getZ() + a3 * v3.getZ();
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4, double[] row, int j) {
        row[j] = a1 * v1.getX() + a2 * v2.getX() + a3 * v3.getX() + a4 * v4.getX();
        row[j + 1] = a1 * v1.getY() + a2 * v2.getY() + a3 * v3.getY() + a4 * v4.getY();
        row[j + 2] = a1 * v1.getZ() + a2 * v2.getZ() + a3 * v3.getZ() + a4 * v4.getZ();
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4, double a5, Vector3D v5, double[] row, int j) {
        row[j] = a1 * v1.getX() + a2 * v2.getX() + a3 * v3.getX() + a4 * v4.getX() + a5 * v5.getX();
        row[j + 1] = a1 * v1.getY() + a2 * v2.getY() + a3 * v3.getY() + a4 * v4.getY() + a5 * v5.getY();
        row[j + 2] = a1 * v1.getZ() + a2 * v2.getZ() + a3 * v3.getZ() + a4 * v4.getZ() + a5 * v5.getZ();
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4, double a5, Vector3D v5, double a6, Vector3D v6, double[] row, int j) {
        row[j] = a1 * v1.getX() + a2 * v2.getX() + a3 * v3.getX() + a4 * v4.getX() + a5 * v5.getX() + a6 * v6.getX();
        row[j + 1] = a1 * v1.getY() + a2 * v2.getY() + a3 * v3.getY() + a4 * v4.getY() + a5 * v5.getY() + a6 * v6.getY();
        row[j + 2] = a1 * v1.getZ() + a2 * v2.getZ() + a3 * v3.getZ() + a4 * v4.getZ() + a5 * v5.getZ() + a6 * v6.getZ();
    }
}

