/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.analysis.interpolation.HermiteInterpolator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.LofOffset;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SpacecraftState
implements TimeStamped,
TimeShiftable<SpacecraftState>,
TimeInterpolable<SpacecraftState>,
Serializable {
    private static final long serialVersionUID = 20130407L;
    private static final double DEFAULT_MASS = 1000.0;
    private static final double DATE_INCONSISTENCY_THRESHOLD = 1.0E-7;
    private final Orbit orbit;
    private final Attitude attitude;
    private final double mass;
    private final Map<String, double[]> additional;

    public SpacecraftState(Orbit orbit) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), 1000.0, null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude) throws IllegalArgumentException {
        this(orbit, attitude, 1000.0, null);
    }

    public SpacecraftState(Orbit orbit, double mass) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass) throws IllegalArgumentException {
        this(orbit, attitude, mass, null);
    }

    public SpacecraftState(Orbit orbit, Map<String, double[]> additional) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), 1000.0, additional);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, Map<String, double[]> additional) throws IllegalArgumentException {
        this(orbit, attitude, 1000.0, additional);
    }

    public SpacecraftState(Orbit orbit, double mass, Map<String, double[]> additional) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, additional);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass, Map<String, double[]> additional) throws IllegalArgumentException {
        SpacecraftState.checkConsistency(orbit, attitude);
        this.orbit = orbit;
        this.attitude = attitude;
        this.mass = mass;
        if (additional == null) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, double[]>(additional.size());
            for (Map.Entry<String, double[]> entry : additional.entrySet()) {
                this.additional.put(entry.getKey(), (double[])entry.getValue().clone());
            }
        }
    }

    public SpacecraftState addAdditionalState(String name, double ... value) {
        HashMap<String, double[]> newMap = new HashMap<String, double[]>(this.additional.size() + 1);
        newMap.putAll(this.additional);
        newMap.put(name, (double[])value.clone());
        return new SpacecraftState(this.orbit, this.attitude, this.mass, newMap);
    }

    private static void checkConsistency(Orbit orbit, Attitude attitude) throws IllegalArgumentException {
        if (FastMath.abs((double)orbit.getDate().durationFrom(attitude.getDate())) > 1.0E-7) {
            throw OrekitException.createIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, orbit.getDate(), attitude.getDate());
        }
        if (orbit.getFrame() != attitude.getReferenceFrame()) {
            throw OrekitException.createIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, orbit.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    @Override
    public SpacecraftState shiftedBy(double dt) {
        return new SpacecraftState(this.orbit.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.additional);
    }

    @Override
    public SpacecraftState interpolate(AbsoluteDate date, Collection<SpacecraftState> sample) throws OrekitException {
        HashMap<String, double[]> interpolatedAdditional;
        ArrayList<Orbit> orbits = new ArrayList<Orbit>(sample.size());
        ArrayList<Attitude> attitudes = new ArrayList<Attitude>(sample.size());
        HermiteInterpolator massInterpolator = new HermiteInterpolator();
        HashMap<String, HermiteInterpolator> additionalInterpolators = new HashMap<String, HermiteInterpolator>(this.additional.size());
        for (String name : this.additional.keySet()) {
            additionalInterpolators.put(name, new HermiteInterpolator());
        }
        for (SpacecraftState state : sample) {
            double deltaT = state.getDate().durationFrom(date);
            orbits.add(state.getOrbit());
            attitudes.add(state.getAttitude());
            massInterpolator.addSamplePoint(deltaT, (double[][])new double[][]{{state.getMass()}});
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                ((HermiteInterpolator)entry.getValue()).addSamplePoint(deltaT, (double[][])new double[][]{state.getAdditionalState((String)entry.getKey())});
            }
        }
        Orbit interpolatedOrbit = (Orbit)this.orbit.interpolate(date, orbits);
        TimeInterpolable interpolatedAttitude = this.attitude.interpolate(date, attitudes);
        double interpolatedMass = massInterpolator.value(0.0)[0];
        if (this.additional.isEmpty()) {
            interpolatedAdditional = null;
        } else {
            interpolatedAdditional = new HashMap<String, double[]>(this.additional.size());
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                interpolatedAdditional.put((String)entry.getKey(), ((HermiteInterpolator)entry.getValue()).value(0.0));
            }
        }
        return new SpacecraftState(interpolatedOrbit, (Attitude)interpolatedAttitude, interpolatedMass, interpolatedAdditional);
    }

    public Orbit getOrbit() {
        return this.orbit;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.orbit.getDate();
    }

    public Frame getFrame() {
        return this.orbit.getFrame();
    }

    public boolean hasAdditionalState(String name) {
        return this.additional.containsKey(name);
    }

    public void ensureCompatibleAdditionalStates(SpacecraftState state) throws OrekitException, DimensionMismatchException {
        for (Map.Entry<String, double[]> entry : this.additional.entrySet()) {
            double[] other = state.additional.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == entry.getValue().length) continue;
            throw new DimensionMismatchException(other.length, entry.getValue().length);
        }
        if (state.additional.size() > this.additional.size()) {
            for (String name : state.additional.keySet()) {
                if (this.additional.containsKey(name)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
            }
        }
    }

    public double[] getAdditionalState(String name) throws OrekitException {
        if (!this.additional.containsKey(name)) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return (double[])this.additional.get(name).clone();
    }

    public Map<String, double[]> getAdditionalStates() {
        return Collections.unmodifiableMap(this.additional);
    }

    public Transform toTransform() {
        AbsoluteDate date = this.orbit.getDate();
        return new Transform(date, new Transform(date, this.orbit.getPVCoordinates().negate()), new Transform(date, this.attitude.getOrientation()));
    }

    public double getMu() {
        return this.orbit.getMu();
    }

    public double getKeplerianPeriod() {
        return this.orbit.getKeplerianPeriod();
    }

    public double getKeplerianMeanMotion() {
        return this.orbit.getKeplerianMeanMotion();
    }

    public double getA() {
        return this.orbit.getA();
    }

    public double getEquinoctialEx() {
        return this.orbit.getEquinoctialEx();
    }

    public double getEquinoctialEy() {
        return this.orbit.getEquinoctialEy();
    }

    public double getHx() {
        return this.orbit.getHx();
    }

    public double getHy() {
        return this.orbit.getHy();
    }

    public double getLv() {
        return this.orbit.getLv();
    }

    public double getLE() {
        return this.orbit.getLE();
    }

    public double getLM() {
        return this.orbit.getLM();
    }

    public double getE() {
        return this.orbit.getE();
    }

    public double getI() {
        return this.orbit.getI();
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        return this.orbit.getPVCoordinates();
    }

    public TimeStampedPVCoordinates getPVCoordinates(Frame outputFrame) throws OrekitException {
        return this.orbit.getPVCoordinates(outputFrame);
    }

    public Attitude getAttitude() {
        return this.attitude;
    }

    public double getMass() {
        return this.mass;
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140617L;
        private final Orbit orbit;
        private double[] d;
        private final Map<String, double[]> additional;

        private DTO(SpacecraftState state) {
            this.orbit = state.orbit;
            this.additional = state.additional.isEmpty() ? null : state.additional;
            Rotation rotation = state.attitude.getRotation();
            Vector3D spin = state.attitude.getSpin();
            Vector3D rotationAcceleration = state.attitude.getRotationAcceleration();
            this.d = new double[]{rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3(), spin.getX(), spin.getY(), spin.getZ(), rotationAcceleration.getX(), rotationAcceleration.getY(), rotationAcceleration.getZ(), state.mass};
        }

        private Object readResolve() {
            return new SpacecraftState(this.orbit, new Attitude(this.orbit.getFrame(), new TimeStampedAngularCoordinates(this.orbit.getDate(), new Rotation(this.d[0], this.d[1], this.d[2], this.d[3], false), new Vector3D(this.d[4], this.d[5], this.d[6]), new Vector3D(this.d[7], this.d[8], this.d[9]))), this.d[10], this.additional);
        }
    }
}

