/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorConverter;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractPropagatorConverter
implements PropagatorConverter {
    private List<SpacecraftState> sample;
    private AbsoluteDate date;
    private double[] target;
    private double[] weight;
    private double rms;
    private boolean onlyPosition;
    private Propagator adapted;
    private Collection<String> parameters;
    private final Collection<String> availableParameters;
    private final PropagatorBuilder builder;
    private final Frame frame;
    private final LevenbergMarquardtOptimizer optimizer;
    private LeastSquaresOptimizer.Optimum optimum;
    private final ConvergenceChecker<LeastSquaresProblem.Evaluation> checker;
    private final int maxIterations;

    protected AbstractPropagatorConverter(PropagatorBuilder builder, double threshold, int maxIterations) {
        this.builder = builder;
        this.frame = builder.getFrame();
        this.availableParameters = builder.getParametersNames();
        this.optimizer = new LevenbergMarquardtOptimizer();
        this.maxIterations = maxIterations;
        this.sample = new ArrayList<SpacecraftState>();
        SimpleVectorValueChecker svvc = new SimpleVectorValueChecker(-1.0, threshold);
        this.checker = LeastSquaresFactory.evaluationChecker((ConvergenceChecker)svvc);
    }

    @Override
    public Propagator convert(Propagator source, double timeSpan, int nbPoints, Collection<String> freeParameters) throws OrekitException {
        this.checkParameters(freeParameters);
        List<SpacecraftState> states = this.createSample(source, timeSpan, nbPoints);
        return this.convert(states, false, freeParameters);
    }

    @Override
    public Propagator convert(Propagator source, double timeSpan, int nbPoints, String ... freeParameters) throws OrekitException {
        this.checkParameters(freeParameters);
        List<SpacecraftState> states = this.createSample(source, timeSpan, nbPoints);
        return this.convert(states, false, freeParameters);
    }

    @Override
    public Propagator convert(List<SpacecraftState> states, boolean positionOnly, Collection<String> freeParameters) throws OrekitException {
        this.checkParameters(freeParameters);
        this.parameters = new ArrayList<String>();
        this.parameters.addAll(freeParameters);
        this.builder.setFreeParameters(this.parameters);
        return this.adapt(states, positionOnly);
    }

    @Override
    public Propagator convert(List<SpacecraftState> states, boolean positionOnly, String ... freeParameters) throws OrekitException {
        this.checkParameters(freeParameters);
        this.parameters = new ArrayList<String>();
        for (String name : freeParameters) {
            this.parameters.add(name);
        }
        this.builder.setFreeParameters(this.parameters);
        return this.adapt(states, positionOnly);
    }

    public Collection<String> getAvailableParameters() {
        return this.availableParameters;
    }

    public boolean isAvailable(String name) {
        for (String supportedName : this.availableParameters) {
            if (!supportedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Propagator getAdaptedPropagator() {
        return this.adapted;
    }

    public double getRMS() {
        return this.rms;
    }

    public int getEvaluations() {
        return this.optimum.getEvaluations();
    }

    protected abstract MultivariateVectorFunction getObjectiveFunction();

    protected abstract MultivariateMatrixFunction getObjectiveFunctionJacobian();

    protected boolean isOnlyPosition() {
        return this.onlyPosition;
    }

    protected int getTargetSize() {
        return this.target.length;
    }

    protected AbsoluteDate getDate() {
        return this.date;
    }

    protected Frame getFrame() {
        return this.frame;
    }

    protected List<SpacecraftState> getSample() {
        return this.sample;
    }

    protected Collection<String> getFreeParameters() {
        return this.parameters;
    }

    private List<SpacecraftState> createSample(Propagator source, double timeSpan, int nbPoints) throws OrekitException {
        SpacecraftState initialState = source.getInitialState();
        ArrayList<SpacecraftState> states = new ArrayList<SpacecraftState>();
        double stepSize = timeSpan / (double)(nbPoints - 1);
        AbsoluteDate iniDate = source.getInitialState().getDate();
        for (double dt = 0.0; dt < timeSpan; dt += stepSize) {
            states.add(source.propagate(iniDate.shiftedBy(dt)));
        }
        source.resetInitialState(initialState);
        return states;
    }

    private void checkParameters(Collection<String> freeParameters) throws OrekitException {
        for (String parameter : freeParameters) {
            this.checkParameter(parameter);
        }
    }

    private void checkParameters(String ... freeParameters) throws OrekitException {
        for (String parameter : freeParameters) {
            this.checkParameter(parameter);
        }
    }

    private void checkParameter(String parameter) throws OrekitException {
        if (!this.availableParameters.contains(parameter)) {
            StringBuilder sBuilder = new StringBuilder();
            for (String available : this.availableParameters) {
                if (sBuilder.length() > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(available);
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, parameter, sBuilder.toString());
        }
    }

    private Propagator adapt(List<SpacecraftState> states, boolean positionOnly) throws OrekitException {
        this.date = states.get(0).getDate();
        this.onlyPosition = positionOnly;
        double[] initial = new double[6 + this.parameters.size()];
        TimeStampedPVCoordinates pv = states.get(0).getPVCoordinates(this.frame);
        initial[0] = pv.getPosition().getX();
        initial[1] = pv.getPosition().getY();
        initial[2] = pv.getPosition().getZ();
        initial[3] = pv.getVelocity().getX();
        initial[4] = pv.getVelocity().getY();
        initial[5] = pv.getVelocity().getZ();
        int i = 6;
        for (String name : this.parameters) {
            initial[i++] = this.builder.getParameter(name);
        }
        this.setSample(states.subList(0, this.onlyPosition ? 2 : 1));
        double[] intermediate = this.fit(initial);
        this.setSample(states);
        double[] result = this.fit(intermediate);
        this.rms = this.getRMS(result);
        this.adapted = this.buildAdaptedPropagator(result);
        return this.adapted;
    }

    private double[] fit(double[] initial) throws OrekitException, MaxCountExceededException {
        final MultivariateVectorFunction f = this.getObjectiveFunction();
        final MultivariateMatrixFunction jac = this.getObjectiveFunctionJacobian();
        MultivariateJacobianFunction fJac = new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                double[] p = point.toArray();
                return new Pair((Object)MatrixUtils.createRealVector((double[])f.value(p)), (Object)MatrixUtils.createRealMatrix((double[][])jac.value(p)));
            }
        };
        LeastSquaresProblem problem = new LeastSquaresBuilder().maxIterations(this.maxIterations).maxEvaluations(Integer.MAX_VALUE).model(fJac).target(this.target).weight((RealMatrix)new DiagonalMatrix(this.weight)).start(initial).checker(this.checker).build();
        this.optimum = this.optimizer.optimize(problem);
        return this.optimum.getPoint().toArray();
    }

    private double getRMS(double[] parameterSet) throws OrekitException {
        double[] residuals = this.getResiduals(parameterSet);
        double sum2 = 0.0;
        for (double residual : residuals) {
            sum2 += residual * residual;
        }
        return FastMath.sqrt((double)(sum2 / (double)residuals.length));
    }

    private double[] getResiduals(double[] parameterSet) throws OrekitException {
        try {
            double[] residuals = this.getObjectiveFunction().value(parameterSet);
            for (int i = 0; i < residuals.length; ++i) {
                residuals[i] = this.target[i] - residuals[i];
            }
            return residuals;
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
    }

    private Propagator buildAdaptedPropagator(double[] parameterSet) throws OrekitException {
        return this.builder.buildPropagator(this.date, parameterSet);
    }

    private void setSample(List<SpacecraftState> states) throws OrekitException {
        this.sample = states;
        if (this.onlyPosition) {
            this.target = new double[states.size() * 3];
            this.weight = new double[states.size() * 3];
        } else {
            this.target = new double[states.size() * 6];
            this.weight = new double[states.size() * 6];
        }
        int k = 0;
        for (int i = 0; i < states.size(); ++i) {
            TimeStampedPVCoordinates pv = states.get(i).getPVCoordinates(this.frame);
            this.target[k] = pv.getPosition().getX();
            this.weight[k++] = 1.0;
            this.target[k] = pv.getPosition().getY();
            this.weight[k++] = 1.0;
            this.target[k] = pv.getPosition().getZ();
            this.weight[k++] = 1.0;
            if (this.onlyPosition) continue;
            double r2 = pv.getPosition().getNormSq();
            double v = pv.getVelocity().getNorm();
            double vWeight = v * r2 / states.get(i).getMu();
            this.target[k] = pv.getVelocity().getX();
            this.weight[k++] = vWeight;
            this.target[k] = pv.getVelocity().getY();
            this.weight[k++] = vWeight;
            this.target[k] = pv.getVelocity().getZ();
            this.weight[k++] = vWeight;
        }
    }
}

