/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.nonstiff.HighamHall54Integrator;
import org.orekit.errors.PropagationException;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.FirstOrderIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public class HighamHall54IntegratorBuilder
implements FirstOrderIntegratorBuilder {
    private final double minStep;
    private final double maxStep;
    private final double dP;

    public HighamHall54IntegratorBuilder(double minStep, double maxStep, double dP) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit) throws PropagationException {
        double[][] tol = NumericalPropagator.tolerances(this.dP, orbit, OrbitType.CARTESIAN);
        return new HighamHall54Integrator(this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

