/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.PropagationException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorConverter;
import org.orekit.propagation.conversion.NumericalPropagatorBuilder;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.PartialDerivativesEquations;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class JacobianPropagatorConverter
extends AbstractPropagatorConverter {
    private final NumericalPropagatorBuilder builder;

    public JacobianPropagatorConverter(NumericalPropagatorBuilder builder, double threshold, int maxIterations) {
        super(builder, threshold, maxIterations);
        this.builder = builder;
    }

    @Override
    protected MultivariateVectorFunction getObjectiveFunction() {
        return new ObjectiveFunction();
    }

    @Override
    protected MultivariateMatrixFunction getObjectiveFunctionJacobian() {
        return new ObjectiveFunctionJacobian();
    }

    private static class JacobianHandler
    implements OrekitStepHandler {
        private transient JacobiansMapper mapper;
        private final double[][] dYdY0;
        private final double[][] dYdP;

        public JacobianHandler(JacobiansMapper mapper) {
            this.mapper = mapper;
            this.dYdY0 = new double[mapper.getStateDimension()][mapper.getStateDimension()];
            this.dYdP = new double[mapper.getStateDimension()][mapper.getParameters()];
        }

        public double[][] getdYdY0() {
            return this.dYdY0;
        }

        public double[][] getdYdP() {
            return this.dYdP;
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator, boolean isLast) throws PropagationException {
            try {
                if (isLast) {
                    interpolator.setInterpolatedDate(interpolator.getCurrentDate());
                    SpacecraftState state = interpolator.getInterpolatedState();
                    this.mapper.getStateJacobian(state, this.dYdY0);
                    this.mapper.getParametersJacobian(state, this.dYdP);
                }
            }
            catch (PropagationException pe) {
                throw pe;
            }
            catch (OrekitException oe) {
                throw new PropagationException(oe);
            }
        }
    }

    private class ObjectiveFunctionJacobian
    implements MultivariateMatrixFunction {
        private ObjectiveFunctionJacobian() {
        }

        public double[][] value(double[] arg) throws IllegalArgumentException, OrekitExceptionWrapper {
            try {
                double[][] jacob = new double[JacobianPropagatorConverter.this.getTargetSize()][arg.length];
                NumericalPropagator prop = JacobianPropagatorConverter.this.builder.buildPropagator(JacobianPropagatorConverter.this.getDate(), arg);
                int stateSize = JacobianPropagatorConverter.this.isOnlyPosition() ? 3 : 6;
                int paramSize = JacobianPropagatorConverter.this.getFreeParameters().size();
                PartialDerivativesEquations pde = new PartialDerivativesEquations("pde", prop);
                pde.selectParameters(JacobianPropagatorConverter.this.getFreeParameters().toArray(new String[0]));
                prop.setInitialState(pde.setInitialJacobians(prop.getInitialState(), stateSize, paramSize));
                JacobiansMapper mapper = pde.getMapper();
                JacobianHandler handler = new JacobianHandler(mapper);
                prop.setMasterMode(handler);
                int i = 0;
                for (SpacecraftState state : JacobianPropagatorConverter.this.getSample()) {
                    prop.propagate(state.getDate());
                    double[][] dYdY0 = handler.getdYdY0();
                    double[][] dYdP = handler.getdYdP();
                    int k = 0;
                    while (k < stateSize) {
                        System.arraycopy(dYdY0[k], 0, jacob[i], 0, stateSize);
                        System.arraycopy(dYdP[k], 0, jacob[i], stateSize, paramSize);
                        ++k;
                        ++i;
                    }
                }
                return jacob;
            }
            catch (OrekitException ex) {
                ex.printStackTrace(System.err);
                throw new OrekitExceptionWrapper(ex);
            }
        }
    }

    private class ObjectiveFunction
    implements MultivariateVectorFunction {
        private ObjectiveFunction() {
        }

        public double[] value(double[] arg) throws IllegalArgumentException, OrekitExceptionWrapper {
            try {
                double[] eval = new double[JacobianPropagatorConverter.this.getTargetSize()];
                NumericalPropagator prop = JacobianPropagatorConverter.this.builder.buildPropagator(JacobianPropagatorConverter.this.getDate(), arg);
                int k = 0;
                for (SpacecraftState state : JacobianPropagatorConverter.this.getSample()) {
                    TimeStampedPVCoordinates pv = prop.getPVCoordinates(state.getDate(), JacobianPropagatorConverter.this.getFrame());
                    eval[k++] = pv.getPosition().getX();
                    eval[k++] = pv.getPosition().getY();
                    eval[k++] = pv.getPosition().getZ();
                    if (JacobianPropagatorConverter.this.isOnlyPosition()) continue;
                    eval[k++] = pv.getVelocity().getX();
                    eval[k++] = pv.getVelocity().getY();
                    eval[k++] = pv.getVelocity().getZ();
                }
                return eval;
            }
            catch (OrekitException ex) {
                throw new OrekitExceptionWrapper(ex);
            }
        }
    }
}

