/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class KeplerianPropagatorBuilder
extends AbstractParameterizable
implements PropagatorBuilder {
    private final double mu;
    private final Frame frame;
    private Collection<String> freeParameters;

    public KeplerianPropagatorBuilder(double mu, Frame frame) {
        super(new String[0]);
        this.mu = mu;
        this.frame = frame;
    }

    @Override
    public Propagator buildPropagator(AbsoluteDate date, double[] parameters) throws OrekitException {
        if (parameters.length != this.freeParameters.size() + 6) {
            throw OrekitException.createIllegalArgumentException((Localizable)LocalizedFormats.DIMENSIONS_MISMATCH, new Object[0]);
        }
        KeplerianOrbit orb = new KeplerianOrbit(new PVCoordinates(new Vector3D(parameters[0], parameters[1], parameters[2]), new Vector3D(parameters[3], parameters[4], parameters[5])), this.frame, date, this.mu);
        return new KeplerianPropagator(orb);
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void setFreeParameters(Collection<String> parameters) throws IllegalArgumentException {
        this.freeParameters = new ArrayList<String>();
        for (String name : parameters) {
            this.complainIfNotSupported(name);
        }
        this.freeParameters.addAll(parameters);
    }

    public double getParameter(String name) throws IllegalArgumentException {
        return 0.0;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
    }
}

