/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.FirstOrderIntegratorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class NumericalPropagatorBuilder
implements PropagatorBuilder {
    private final double mu;
    private final Frame frame;
    private final FirstOrderIntegratorBuilder builder;
    private final List<ForceModel> forceModels;
    private double mass;
    private AttitudeProvider attProvider;
    private Collection<String> freeParameters;

    public NumericalPropagatorBuilder(double mu, Frame frame, FirstOrderIntegratorBuilder builder) {
        this.mu = mu;
        this.frame = frame;
        this.builder = builder;
        this.forceModels = new ArrayList<ForceModel>();
        this.mass = 1000.0;
        this.attProvider = Propagator.DEFAULT_LAW;
    }

    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attProvider = attitudeProvider;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void addForceModel(ForceModel model) {
        this.forceModels.add(model);
    }

    @Override
    public NumericalPropagator buildPropagator(AbsoluteDate date, double[] parameters) throws OrekitException {
        if (parameters.length != this.freeParameters.size() + 6) {
            throw OrekitException.createIllegalArgumentException((Localizable)LocalizedFormats.DIMENSIONS_MISMATCH, new Object[0]);
        }
        CartesianOrbit orb = new CartesianOrbit(new PVCoordinates(new Vector3D(parameters[0], parameters[1], parameters[2]), new Vector3D(parameters[3], parameters[4], parameters[5])), this.frame, date, this.mu);
        Attitude attitude = this.attProvider.getAttitude(orb, date, this.frame);
        SpacecraftState state = new SpacecraftState((Orbit)orb, attitude, this.mass);
        Iterator<String> freeItr = this.freeParameters.iterator();
        for (int i = 6; i < parameters.length; ++i) {
            String free = freeItr.next();
            for (String available : this.getParametersNames()) {
                if (!free.equals(available)) continue;
                this.setParameter(free, parameters[i]);
            }
        }
        NumericalPropagator propagator = new NumericalPropagator(this.builder.buildIntegrator(orb));
        propagator.setOrbitType(OrbitType.CARTESIAN);
        propagator.setAttitudeProvider(this.attProvider);
        for (ForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        propagator.resetInitialState(state);
        return propagator;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void setFreeParameters(Collection<String> parameters) throws IllegalArgumentException {
        this.freeParameters = new ArrayList<String>();
        for (String name : parameters) {
            if (this.isSupported(name)) continue;
            throw OrekitException.createIllegalArgumentException((Localizable)LocalizedFormats.UNKNOWN_PARAMETER, name);
        }
        this.freeParameters.addAll(parameters);
    }

    public Collection<String> getParametersNames() {
        ArrayList<String> parametersNames = new ArrayList<String>();
        for (ForceModel model : this.forceModels) {
            parametersNames.addAll(model.getParametersNames());
        }
        return parametersNames;
    }

    public boolean isSupported(String name) {
        for (ForceModel model : this.forceModels) {
            if (!model.isSupported(name)) continue;
            return true;
        }
        return false;
    }

    public double getParameter(String name) throws IllegalArgumentException {
        for (ForceModel model : this.forceModels) {
            if (!model.isSupported(name)) continue;
            return model.getParameter(name);
        }
        throw new IllegalArgumentException(name);
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        for (ForceModel model : this.forceModels) {
            if (!model.isSupported(name)) continue;
            model.setParameter(name, value);
            break;
        }
    }
}

