/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class TLEPropagatorBuilder
extends AbstractParameterizable
implements PropagatorBuilder {
    public static final String B_STAR = "BSTAR";
    private final int satelliteNumber;
    private final char classification;
    private final int launchYear;
    private final int launchNumber;
    private final String launchPiece;
    private final int elementNumber;
    private final int revolutionNumberAtEpoch;
    private final double mu;
    private final Frame frame;
    private Collection<String> freeParameters;
    private double bStar;

    public TLEPropagatorBuilder(int satelliteNumber, char classification, int launchYear, int launchNumber, String launchPiece, int elementNumber, int revolutionNumberAtEpoch) throws OrekitException {
        super(new String[]{B_STAR});
        this.satelliteNumber = satelliteNumber;
        this.classification = classification;
        this.launchYear = launchYear;
        this.launchNumber = launchNumber;
        this.launchPiece = launchPiece;
        this.elementNumber = elementNumber;
        this.revolutionNumberAtEpoch = revolutionNumberAtEpoch;
        this.bStar = 0.0;
        this.mu = TLEPropagator.getMU();
        this.frame = FramesFactory.getTEME();
    }

    @Override
    public Propagator buildPropagator(AbsoluteDate date, double[] parameters) throws OrekitException {
        if (parameters.length != this.freeParameters.size() + 6) {
            throw OrekitException.createIllegalArgumentException((Localizable)LocalizedFormats.DIMENSIONS_MISMATCH, new Object[0]);
        }
        KeplerianOrbit orb = new KeplerianOrbit(new PVCoordinates(new Vector3D(parameters[0], parameters[1], parameters[2]), new Vector3D(parameters[3], parameters[4], parameters[5])), this.frame, date, this.mu);
        Iterator<String> freeItr = this.freeParameters.iterator();
        for (int i = 6; i < parameters.length; ++i) {
            String free = freeItr.next();
            for (String available : this.getParametersNames()) {
                if (!free.equals(available)) continue;
                this.setParameter(free, parameters[i]);
            }
        }
        TLE tle = new TLE(this.satelliteNumber, this.classification, this.launchYear, this.launchNumber, this.launchPiece, 0, this.elementNumber, date, orb.getKeplerianMeanMotion(), 0.0, 0.0, orb.getE(), MathUtils.normalizeAngle((double)orb.getI(), (double)Math.PI), MathUtils.normalizeAngle((double)orb.getPerigeeArgument(), (double)Math.PI), MathUtils.normalizeAngle((double)orb.getRightAscensionOfAscendingNode(), (double)Math.PI), MathUtils.normalizeAngle((double)orb.getMeanAnomaly(), (double)Math.PI), this.revolutionNumberAtEpoch, this.bStar);
        return TLEPropagator.selectExtrapolator(tle);
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void setFreeParameters(Collection<String> parameters) throws IllegalArgumentException {
        this.freeParameters = new ArrayList<String>();
        for (String name : parameters) {
            this.complainIfNotSupported(name);
        }
        this.freeParameters.addAll(parameters);
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.bStar;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.bStar = value * 1.0E-4;
    }
}

