/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class DihedralFieldOfViewDetector
extends AbstractDetector<DihedralFieldOfViewDetector> {
    private static final long serialVersionUID = 20131118L;
    private final PVCoordinatesProvider targetPVProvider;
    private final Vector3D center;
    private final Vector3D axis1;
    private final Vector3D normalCenterPlane1;
    private final double halfAperture1;
    private final Vector3D axis2;
    private final Vector3D normalCenterPlane2;
    private final double halfAperture2;

    public DihedralFieldOfViewDetector(double maxCheck, PVCoordinatesProvider pvTarget, Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2) {
        this(maxCheck, 0.001, 100, new StopOnDecreasing<DihedralFieldOfViewDetector>(), pvTarget, center, axis1, halfAperture1, axis2, halfAperture2);
    }

    private DihedralFieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<DihedralFieldOfViewDetector> handler, PVCoordinatesProvider pvTarget, Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2) {
        super(maxCheck, threshold, maxIter, handler);
        this.targetPVProvider = pvTarget;
        this.center = center;
        this.axis1 = axis1;
        this.normalCenterPlane1 = Vector3D.crossProduct((Vector3D)axis1, (Vector3D)center);
        this.axis2 = axis2;
        this.normalCenterPlane2 = Vector3D.crossProduct((Vector3D)axis2, (Vector3D)center);
        this.halfAperture1 = halfAperture1;
        this.halfAperture2 = halfAperture2;
    }

    @Override
    protected DihedralFieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<DihedralFieldOfViewDetector> newHandler) {
        return new DihedralFieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.targetPVProvider, this.center, this.axis1, this.halfAperture1, this.axis2, this.halfAperture2);
    }

    public PVCoordinatesProvider getPVTarget() {
        return this.targetPVProvider;
    }

    public Vector3D getCenter() {
        return this.center;
    }

    public Vector3D getAxis1() {
        return this.axis1;
    }

    public double getHalfAperture1() {
        return this.halfAperture1;
    }

    public double getHalfAperture2() {
        return this.halfAperture2;
    }

    public Vector3D getAxis2() {
        return this.axis2;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        Vector3D targetPosInert = new Vector3D(1.0, this.targetPVProvider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), -1.0, s.getPVCoordinates().getPosition());
        Vector3D targetPosSat = s.getAttitude().getRotation().applyTo(targetPosInert);
        double angle1 = FastMath.atan2((double)Vector3D.dotProduct((Vector3D)targetPosSat, (Vector3D)this.normalCenterPlane1), (double)Vector3D.dotProduct((Vector3D)targetPosSat, (Vector3D)this.center));
        double angle2 = FastMath.atan2((double)Vector3D.dotProduct((Vector3D)targetPosSat, (Vector3D)this.normalCenterPlane2), (double)Vector3D.dotProduct((Vector3D)targetPosSat, (Vector3D)this.center));
        return FastMath.min((double)(this.halfAperture1 - FastMath.abs((double)angle1)), (double)(this.halfAperture2 - FastMath.abs((double)angle2)));
    }
}

