/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.Arrays;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FilterType;
import org.orekit.propagation.events.Transformer;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventFilter<T extends EventDetector>
extends AbstractDetector<EventFilter<T>> {
    private static final long serialVersionUID = 20130409L;
    private static final int HISTORY_SIZE = 100;
    private final T rawDetector;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final AbsoluteDate[] updates;
    private boolean forward;
    private AbsoluteDate extremeT;

    public EventFilter(T rawDetector, FilterType filter) {
        this(rawDetector.getMaxCheckInterval(), rawDetector.getThreshold(), rawDetector.getMaxIterationCount(), new LocalHandler(), rawDetector, filter);
    }

    private EventFilter(double maxCheck, double threshold, int maxIter, EventHandler<EventFilter<T>> handler, T rawDetector, FilterType filter) {
        super(maxCheck, threshold, maxIter, handler);
        this.rawDetector = rawDetector;
        this.filter = filter;
        this.transformers = new Transformer[100];
        this.updates = new AbsoluteDate[100];
    }

    @Override
    protected EventFilter<T> create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<EventFilter<T>> newHandler) {
        return new EventFilter<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.rawDetector, this.filter);
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.rawDetector.init(s0, t);
        this.forward = t.compareTo(s0.getDate()) >= 0;
        this.extremeT = this.forward ? AbsoluteDate.PAST_INFINITY : AbsoluteDate.FUTURE_INFINITY;
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        double rawG = this.rawDetector.g(s);
        if (this.forward) {
            int last = this.transformers.length - 1;
            if (this.extremeT.compareTo(s.getDate()) < 0) {
                Transformer previous = this.transformers[last];
                Transformer next = this.filter.selectTransformer(previous, rawG, this.forward);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last);
                    this.updates[last] = this.extremeT;
                    this.transformers[last] = next;
                }
                this.extremeT = s.getDate();
                return next.transformed(rawG);
            }
            for (int i = last; i > 0; --i) {
                if (this.updates[i].compareTo(s.getDate()) > 0) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (s.getDate().compareTo(this.extremeT) < 0) {
            Transformer previous = this.transformers[0];
            Transformer next = this.filter.selectTransformer(previous, rawG, this.forward);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = s.getDate();
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (s.getDate().compareTo(this.updates[i]) > 0) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    private static class LocalHandler<T extends EventDetector>
    implements EventHandler<EventFilter<T>> {
        private LocalHandler() {
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, EventFilter<T> ef, boolean increasing) throws OrekitException {
            return ((EventFilter)ef).rawDetector.eventOccurred(s, ((EventFilter)ef).filter.getTriggeredIncreasing());
        }

        @Override
        public SpacecraftState resetState(EventFilter<T> ef, SpacecraftState oldState) throws OrekitException {
            return ((EventFilter)ef).rawDetector.resetState(oldState);
        }
    }
}

