/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventsLogger
implements Serializable {
    private static final long serialVersionUID = -8643810076248572648L;
    private final List<LoggedEvent> log = new ArrayList<LoggedEvent>();

    public <T extends EventDetector> EventDetector monitorDetector(T monitoredDetector) {
        return new LoggingWrapper(this, monitoredDetector);
    }

    public void clearLoggedEvents() {
        this.log.clear();
    }

    public List<LoggedEvent> getLoggedEvents() {
        return new ArrayList<LoggedEvent>(this.log);
    }

    private static class LocalHandler<T extends EventDetector>
    implements EventHandler<LoggingWrapper<T>> {
        private LocalHandler() {
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, LoggingWrapper<T> wrapper, boolean increasing) throws OrekitException {
            wrapper.logEvent(s, increasing);
            return ((LoggingWrapper)wrapper).detector.eventOccurred(s, increasing);
        }

        @Override
        public SpacecraftState resetState(LoggingWrapper<T> wrapper, SpacecraftState oldState) throws OrekitException {
            return ((LoggingWrapper)wrapper).detector.resetState(oldState);
        }
    }

    private class LoggingWrapper<T extends EventDetector>
    extends AbstractDetector<LoggingWrapper<T>> {
        private static final long serialVersionUID = 20131118L;
        private final T detector;
        final /* synthetic */ EventsLogger this$0;

        public LoggingWrapper(T detector) {
            this(var1_1, detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount(), new LocalHandler(), (EventDetector)detector);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private LoggingWrapper(double maxIter, double detector, int n, EventHandler<LoggingWrapper<T>> eventHandler, T t) {
            void handler;
            void threshold;
            void maxCheck;
            this.this$0 = (EventsLogger)d;
            super((double)maxCheck, (double)threshold, (int)maxIter, handler);
            this.detector = detector;
        }

        @Override
        protected LoggingWrapper<T> create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<LoggingWrapper<T>> newHandler) {
            return new LoggingWrapper(this.this$0, newMaxCheck, newThreshold, newMaxIter, newHandler, this.detector);
        }

        public void logEvent(SpacecraftState state, boolean increasing) {
            this.this$0.log.add(new LoggedEvent((EventDetector)this.detector, state, increasing));
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.detector.init(s0, t);
        }

        @Override
        public double g(SpacecraftState s) throws OrekitException {
            return this.detector.g(s);
        }
    }

    public static class LoggedEvent
    implements Serializable {
        private static final long serialVersionUID = 20131202L;
        private final EventDetector detector;
        private final SpacecraftState state;
        private final boolean increasing;

        private LoggedEvent(EventDetector detector, SpacecraftState state, boolean increasing) {
            this.detector = detector;
            this.state = state;
            this.increasing = increasing;
        }

        public EventDetector getEventDetector() {
            return this.detector;
        }

        public SpacecraftState getState() {
            return this.state;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }
    }
}

