/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.spherical.twod.Circle;
import org.apache.commons.math3.geometry.spherical.twod.S2Point;
import org.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import org.apache.commons.math3.geometry.spherical.twod.SphericalPolygonsSet;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class GeographicZoneDetector
extends AbstractDetector<GeographicZoneDetector> {
    private static final long serialVersionUID = 20140619L;
    private BodyShape body;
    private final transient SphericalPolygonsSet zone;
    private final transient EnclosingBall<Sphere2D, S2Point> cap;
    private final double margin;

    public GeographicZoneDetector(BodyShape body, SphericalPolygonsSet zone, double margin) {
        this(600.0, 1.0E-6, body, zone, margin);
    }

    public GeographicZoneDetector(double maxCheck, double threshold, BodyShape body, SphericalPolygonsSet zone, double margin) {
        this(maxCheck, threshold, 100, new StopOnIncreasing<GeographicZoneDetector>(), body, zone, (EnclosingBall<Sphere2D, S2Point>)zone.getEnclosingCap(), margin);
    }

    private GeographicZoneDetector(double maxCheck, double threshold, int maxIter, EventHandler<GeographicZoneDetector> handler, BodyShape body, SphericalPolygonsSet zone, EnclosingBall<Sphere2D, S2Point> cap, double margin) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.zone = zone;
        this.cap = cap;
        this.margin = margin;
    }

    @Override
    protected GeographicZoneDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<GeographicZoneDetector> newHandler) {
        return new GeographicZoneDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.zone, this.cap, this.margin);
    }

    public GeographicZoneDetector withMargin(double newMargin) {
        return new GeographicZoneDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.body, this.zone, this.cap, newMargin);
    }

    public BodyShape getBody() {
        return this.body;
    }

    public SphericalPolygonsSet getZone() {
        return this.zone;
    }

    public double getMargin() {
        return this.margin;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        S2Point s2p = new S2Point(gp.getLongitude(), 1.5707963267948966 - gp.getLatitude());
        double crudeDistance = ((S2Point)this.cap.getCenter()).distance((Point)s2p) - this.cap.getRadius();
        if (crudeDistance - this.margin > FastMath.max((double)FastMath.abs((double)this.margin), (double)0.01)) {
            return crudeDistance - this.margin;
        }
        return this.zone.projectToBoundary((Point)s2p).getOffset() - this.margin;
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140619L;
        private final double maxCheck;
        private final double threshold;
        private final int maxIter;
        private final BodyShape body;
        private final double margin;
        private final double tolerance;
        private final double[] cuts;
        private final int[] leafs;
        private final boolean[] flags;
        private transient int internalNodes;
        private transient int leafNodes;
        private transient int nodeIndex;
        private transient int cutIndex;
        private transient int flagIndex;

        private DTO(GeographicZoneDetector detector) {
            this.maxCheck = detector.getMaxCheckInterval();
            this.threshold = detector.getThreshold();
            this.maxIter = detector.getMaxIterationCount();
            this.body = detector.body;
            this.margin = detector.margin;
            this.tolerance = detector.zone.getTolerance();
            this.internalNodes = 0;
            this.leafNodes = 0;
            detector.zone.getTree(false).visit((BSPTreeVisitor)new BSPTreeVisitor<Sphere2D>(){

                public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> node) {
                    return BSPTreeVisitor.Order.SUB_MINUS_PLUS;
                }

                public void visitInternalNode(BSPTree<Sphere2D> node) {
                    ++DTO.this.internalNodes;
                }

                public void visitLeafNode(BSPTree<Sphere2D> node) {
                    ++DTO.this.leafNodes;
                }
            });
            this.cuts = new double[3 * this.internalNodes];
            this.leafs = new int[this.leafNodes];
            this.flags = new boolean[this.leafNodes];
            this.nodeIndex = 0;
            this.cutIndex = 0;
            this.flagIndex = 0;
            detector.zone.getTree(false).visit((BSPTreeVisitor)new BSPTreeVisitor<Sphere2D>(){

                public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> node) {
                    return BSPTreeVisitor.Order.SUB_MINUS_PLUS;
                }

                public void visitInternalNode(BSPTree<Sphere2D> node) {
                    Vector3D cutPole = ((Circle)node.getCut().getHyperplane()).getPole();
                    ((DTO)DTO.this).cuts[((DTO)DTO.this).cutIndex++] = cutPole.getX();
                    ((DTO)DTO.this).cuts[((DTO)DTO.this).cutIndex++] = cutPole.getY();
                    ((DTO)DTO.this).cuts[((DTO)DTO.this).cutIndex++] = cutPole.getZ();
                    DTO.this.nodeIndex++;
                }

                public void visitLeafNode(BSPTree<Sphere2D> node) {
                    ((DTO)DTO.this).leafs[((DTO)DTO.this).flagIndex] = DTO.this.nodeIndex++;
                    ((DTO)DTO.this).flags[((DTO)DTO.this).flagIndex++] = (Boolean)node.getAttribute();
                }
            });
        }

        private Object readResolve() {
            BSPTree node = new BSPTree();
            int nbNodes = this.cuts.length / 3 + this.leafs.length;
            this.cutIndex = 0;
            this.flagIndex = 0;
            this.nodeIndex = 0;
            while (this.nodeIndex < nbNodes) {
                if (this.leafs[this.flagIndex] == this.nodeIndex) {
                    node.setAttribute((Object)this.flags[this.flagIndex++]);
                    while (node.getParent() != null) {
                        BSPTree parent = node.getParent();
                        if (node == parent.getMinus()) {
                            node = parent.getPlus();
                            break;
                        }
                        node = parent;
                    }
                } else {
                    double x = this.cuts[this.cutIndex++];
                    double y = this.cuts[this.cutIndex++];
                    double z = this.cuts[this.cutIndex++];
                    node.insertCut((Hyperplane)new Circle(new Vector3D(x, y, z), this.tolerance));
                    node = node.getMinus();
                }
                ++this.nodeIndex;
            }
            return ((GeographicZoneDetector)((GeographicZoneDetector)new GeographicZoneDetector(this.body, new SphericalPolygonsSet(node, this.tolerance), this.margin).withMaxCheck(this.maxCheck)).withThreshold(this.threshold)).withMaxIter(this.maxIter);
        }
    }
}

