/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.ExceptionContextProvider;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.ContinuousOutputModel;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.SecondaryEquations;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AbstractPropagator;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.IntegratedEphemeris;
import org.orekit.propagation.integration.ModeHandler;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractIntegratedPropagator
extends AbstractPropagator {
    private final List<EventDetector> detectors = new ArrayList<EventDetector>();
    private final AbstractIntegrator integrator;
    private ModeHandler modeHandler;
    private List<AdditionalEquations> additionalEquations = new ArrayList<AdditionalEquations>();
    private int calls;
    private StateMapper stateMapper;
    private ExpandableStatefulODE mathODE;
    private StepInterpolator mathInterpolator;
    private boolean meanOrbit;

    protected AbstractIntegratedPropagator(AbstractIntegrator integrator, boolean meanOrbit) {
        this.integrator = integrator;
        this.meanOrbit = meanOrbit;
    }

    protected void initMapper() {
        this.stateMapper = this.createMapper(null, Double.NaN, null, null, null, null);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), attitudeProvider, this.stateMapper.getFrame());
    }

    protected void setOrbitType(OrbitType orbitType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), orbitType, this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected OrbitType getOrbitType() {
        return this.stateMapper.getOrbitType();
    }

    protected boolean isMeanOrbit() {
        return this.meanOrbit;
    }

    protected void setPositionAngleType(PositionAngle positionAngleType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), positionAngleType, this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected PositionAngle getPositionAngleType() {
        return this.stateMapper.getPositionAngleType();
    }

    public void setMu(double mu) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), mu, this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    public double getMu() {
        return this.stateMapper.getMu();
    }

    public int getCalls() {
        return this.calls;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (AdditionalEquations equation : this.additionalEquations) {
            if (!equation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] alreadyIntegrated = super.getManagedAdditionalStates();
        String[] managed = new String[alreadyIntegrated.length + this.additionalEquations.size()];
        System.arraycopy(alreadyIntegrated, 0, managed, 0, alreadyIntegrated.length);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            managed[i + alreadyIntegrated.length] = this.additionalEquations.get(i).getName();
        }
        return managed;
    }

    public void addAdditionalEquations(AdditionalEquations additional) throws OrekitException {
        if (this.isAdditionalStateManaged(additional.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additional.getName());
        }
        this.additionalEquations.add(additional);
    }

    public void addEventDetector(EventDetector detector) {
        this.detectors.add(detector);
    }

    @Override
    public Collection<EventDetector> getEventsDetectors() {
        return Collections.unmodifiableCollection(this.detectors);
    }

    @Override
    public void clearEventsDetectors() {
        this.detectors.clear();
    }

    protected void setUpUserEventDetectors() {
        for (EventDetector detector : this.detectors) {
            this.setUpEventDetector(this.integrator, detector);
        }
    }

    protected void setUpEventDetector(AbstractIntegrator integ, EventDetector detector) {
        integ.addEventHandler((EventHandler)new AdaptedEventDetector(detector), detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount());
    }

    @Override
    public void setSlaveMode() {
        super.setSlaveMode();
        if (this.integrator != null) {
            this.integrator.clearStepHandlers();
        }
        this.modeHandler = null;
    }

    @Override
    public void setMasterMode(OrekitStepHandler handler) {
        super.setMasterMode(handler);
        this.integrator.clearStepHandlers();
        AdaptedStepHandler wrapped = new AdaptedStepHandler(handler);
        this.integrator.addStepHandler((StepHandler)wrapped);
        this.modeHandler = wrapped;
    }

    @Override
    public void setEphemerisMode() {
        super.setEphemerisMode();
        this.integrator.clearStepHandlers();
        EphemerisModeHandler ephemeris = new EphemerisModeHandler();
        this.modeHandler = ephemeris;
        this.integrator.addStepHandler((StepHandler)ephemeris);
    }

    @Override
    public BoundedPropagator getGeneratedEphemeris() throws IllegalStateException {
        if (this.getMode() != 2) {
            throw OrekitException.createIllegalStateException(OrekitMessages.PROPAGATOR_NOT_IN_EPHEMERIS_GENERATION_MODE, new Object[0]);
        }
        return ((EphemerisModeHandler)this.modeHandler).getEphemeris();
    }

    protected abstract StateMapper createMapper(AbsoluteDate var1, double var2, OrbitType var4, PositionAngle var5, AttitudeProvider var6, Frame var7);

    protected abstract MainStateEquations getMainStateEquations(AbstractIntegrator var1);

    @Override
    public SpacecraftState propagate(AbsoluteDate target) throws PropagationException {
        try {
            if (this.getStartDate() == null) {
                if (this.getInitialState() == null) {
                    throw new PropagationException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
                }
                this.setStartDate(this.getInitialState().getDate());
            }
            return this.propagate(this.getStartDate(), target);
        }
        catch (OrekitException oe) {
            for (Throwable t = oe; t != null; t = t.getCause()) {
                if (!(t instanceof PropagationException)) continue;
                throw (PropagationException)t;
            }
            throw new PropagationException(oe);
        }
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate tStart, AbsoluteDate tEnd) throws PropagationException {
        try {
            if (this.getInitialState() == null) {
                throw new PropagationException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
            }
            if (!tStart.equals(this.getInitialState().getDate())) {
                this.propagate(tStart, false);
            }
            return this.propagate(tEnd, true);
        }
        catch (OrekitException oe) {
            for (Throwable t = oe; t != null; t = t.getCause()) {
                if (!(t instanceof PropagationException)) continue;
                throw (PropagationException)t;
            }
            throw new PropagationException(oe);
        }
    }

    protected SpacecraftState propagate(AbsoluteDate tEnd, boolean activateHandlers) throws PropagationException {
        try {
            if (this.getInitialState().getDate().equals(tEnd)) {
                return this.getInitialState();
            }
            this.stateMapper = this.createMapper(this.getInitialState().getDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.getInitialState().getFrame());
            Orbit initialOrbit = this.stateMapper.getOrbitType().convertType(this.getInitialState().getOrbit());
            if (Double.isNaN(this.getMu())) {
                this.setMu(initialOrbit.getMu());
            }
            if (this.getInitialState().getMass() <= 0.0) {
                throw new PropagationException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, this.getInitialState().getMass());
            }
            this.integrator.clearEventHandlers();
            this.setUpUserEventDetectors();
            this.mathODE = this.createODE(this.integrator);
            this.mathInterpolator = null;
            if (this.modeHandler != null) {
                this.modeHandler.initialize(activateHandlers);
            }
            try {
                this.beforeIntegration(this.getInitialState(), tEnd);
                this.integrator.integrate(this.mathODE, tEnd.durationFrom(this.getInitialState().getDate()));
                this.afterIntegration();
            }
            catch (OrekitExceptionWrapper oew) {
                throw oew.getException();
            }
            SpacecraftState finalState = this.stateMapper.mapArrayToState(this.mathODE.getTime(), this.mathODE.getPrimaryState(), this.meanOrbit);
            finalState = this.updateAdditionalStates(finalState);
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                double[] secondary = this.mathODE.getSecondaryState(i);
                finalState = finalState.addAdditionalState(this.additionalEquations.get(i).getName(), secondary);
            }
            this.resetInitialState(finalState);
            this.setStartDate(finalState.getDate());
            return finalState;
        }
        catch (PropagationException pe) {
            throw pe;
        }
        catch (OrekitException oe) {
            throw new PropagationException(oe);
        }
        catch (MathIllegalArgumentException miae) {
            throw PropagationException.unwrap((ExceptionContextProvider)miae);
        }
        catch (MathIllegalStateException mise) {
            throw PropagationException.unwrap((ExceptionContextProvider)mise);
        }
    }

    private ExpandableStatefulODE createODE(AbstractIntegrator integ) throws OrekitException {
        double[] initialStateVector = new double[this.getBasicDimension()];
        this.stateMapper.mapStateToArray(this.getInitialState(), initialStateVector);
        ExpandableStatefulODE ode = new ExpandableStatefulODE((FirstOrderDifferentialEquations)new ConvertedMainStateEquations(this.getMainStateEquations(integ)));
        ode.setTime(0.0);
        ode.setPrimaryState(initialStateVector);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            AdditionalEquations additional = this.additionalEquations.get(i);
            double[] data = this.getInitialState().getAdditionalState(additional.getName());
            ConvertedSecondaryStateEquations secondary = new ConvertedSecondaryStateEquations(additional, data.length);
            ode.addSecondaryEquations((SecondaryEquations)secondary);
            ode.setSecondaryState(i, data);
        }
        return ode;
    }

    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) throws OrekitException {
    }

    protected void afterIntegration() throws OrekitException {
    }

    public int getBasicDimension() {
        return 7;
    }

    protected AbstractIntegrator getIntegrator() {
        return this.integrator;
    }

    private SpacecraftState getCompleteState(double t, double[] y) throws OrekitException {
        SpacecraftState state = this.stateMapper.mapArrayToState(t, y, true);
        state = this.updateAdditionalStates(state);
        if (!this.additionalEquations.isEmpty()) {
            EquationsMapper[] em = this.mathODE.getSecondaryMappers();
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                double[] secondary = new double[em[i].getDimension()];
                System.arraycopy(y, em[i].getFirstIndex(), secondary, 0, secondary.length);
                state = state.addAdditionalState(this.additionalEquations.get(i).getName(), secondary);
            }
        }
        return state;
    }

    private class EphemerisModeHandler
    implements ModeHandler,
    StepHandler {
        private ContinuousOutputModel model;
        private BoundedPropagator ephemeris;
        private boolean activate;

        @Override
        public void initialize(boolean activateHandlers) {
            this.activate = activateHandlers;
            this.model = new ContinuousOutputModel();
            this.ephemeris = null;
        }

        public BoundedPropagator getEphemeris() {
            return this.ephemeris;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws OrekitExceptionWrapper {
            try {
                if (this.activate) {
                    this.model.handleStep(interpolator, isLast);
                    if (isLast) {
                        AbsoluteDate maxDate;
                        AbsoluteDate minDate;
                        double tI = this.model.getInitialTime();
                        double tF = this.model.getFinalTime();
                        AbsoluteDate startDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tI);
                        if (tF < tI) {
                            minDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF);
                            maxDate = startDate;
                        } else {
                            minDate = startDate;
                            maxDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF);
                        }
                        HashMap<String, double[]> unmanaged = new HashMap<String, double[]>();
                        for (Map.Entry<String, double[]> initial : AbstractIntegratedPropagator.this.getInitialState().getAdditionalStates().entrySet()) {
                            if (AbstractIntegratedPropagator.this.isAdditionalStateManaged(initial.getKey())) continue;
                            unmanaged.put(initial.getKey(), initial.getValue());
                        }
                        String[] names = new String[AbstractIntegratedPropagator.this.additionalEquations.size()];
                        for (int i = 0; i < names.length; ++i) {
                            names[i] = ((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName();
                        }
                        this.ephemeris = new IntegratedEphemeris(startDate, minDate, maxDate, AbstractIntegratedPropagator.this.stateMapper, AbstractIntegratedPropagator.this.meanOrbit, this.model, unmanaged, AbstractIntegratedPropagator.this.getAdditionalStateProviders(), names);
                    }
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void init(double t0, double[] y0, double t) {
            this.model.init(t0, y0, t);
        }
    }

    private class AdaptedStepHandler
    implements OrekitStepInterpolator,
    StepHandler,
    ModeHandler {
        private final OrekitStepHandler handler;
        private boolean activate;

        public AdaptedStepHandler(OrekitStepHandler handler) {
            this.handler = handler;
        }

        @Override
        public void initialize(boolean activateHandlers) {
            this.activate = activateHandlers;
        }

        public void init(double t0, double[] y0, double t) {
            try {
                this.handler.init(AbstractIntegratedPropagator.this.getCompleteState(t0, y0), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) {
            try {
                AbstractIntegratedPropagator.this.mathInterpolator = interpolator;
                if (this.activate) {
                    this.handler.handleStep(this, isLast);
                }
            }
            catch (PropagationException pe) {
                throw new OrekitExceptionWrapper(pe);
            }
        }

        @Override
        public AbsoluteDate getCurrentDate() {
            return AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(AbstractIntegratedPropagator.this.mathInterpolator.getCurrentTime());
        }

        @Override
        public AbsoluteDate getPreviousDate() {
            return AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(AbstractIntegratedPropagator.this.mathInterpolator.getPreviousTime());
        }

        @Override
        public AbsoluteDate getInterpolatedDate() {
            return AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(AbstractIntegratedPropagator.this.mathInterpolator.getInterpolatedTime());
        }

        @Override
        public void setInterpolatedDate(AbsoluteDate date) {
            AbstractIntegratedPropagator.this.mathInterpolator.setInterpolatedTime(AbstractIntegratedPropagator.this.stateMapper.mapDateToDouble(date));
        }

        @Override
        public SpacecraftState getInterpolatedState() throws OrekitException {
            try {
                SpacecraftState s = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(AbstractIntegratedPropagator.this.mathInterpolator.getInterpolatedTime(), AbstractIntegratedPropagator.this.mathInterpolator.getInterpolatedState(), AbstractIntegratedPropagator.this.meanOrbit);
                s = AbstractIntegratedPropagator.this.updateAdditionalStates(s);
                for (int i = 0; i < AbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                    double[] secondary = AbstractIntegratedPropagator.this.mathInterpolator.getInterpolatedSecondaryState(i);
                    s = s.addAdditionalState(((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName(), secondary);
                }
                return s;
            }
            catch (OrekitExceptionWrapper oew) {
                throw oew.getException();
            }
        }

        @Override
        public boolean isForward() {
            return AbstractIntegratedPropagator.this.mathInterpolator.isForward();
        }
    }

    private class AdaptedEventDetector
    implements EventHandler {
        private final EventDetector detector;
        private double lastT;
        private double lastG;

        public AdaptedEventDetector(EventDetector detector) {
            this.detector = detector;
            this.lastT = Double.NaN;
            this.lastG = Double.NaN;
        }

        public void init(double t0, double[] y0, double t) {
            try {
                this.detector.init(AbstractIntegratedPropagator.this.getCompleteState(t0, y0), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
                this.lastT = Double.NaN;
                this.lastG = Double.NaN;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public double g(double t, double[] y) {
            try {
                if (!Precision.equals((double)this.lastT, (double)t, (int)1)) {
                    this.lastT = t;
                    this.lastG = this.detector.g(AbstractIntegratedPropagator.this.getCompleteState(t, y));
                }
                return this.lastG;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            try {
                EventHandler.Action whatNext = this.detector.eventOccurred(AbstractIntegratedPropagator.this.getCompleteState(t, y), increasing);
                switch (whatNext) {
                    case STOP: {
                        return EventHandler.Action.STOP;
                    }
                    case RESET_STATE: {
                        return EventHandler.Action.RESET_STATE;
                    }
                    case RESET_DERIVATIVES: {
                        return EventHandler.Action.RESET_DERIVATIVES;
                    }
                }
                return EventHandler.Action.CONTINUE;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void resetState(double t, double[] y) {
            try {
                SpacecraftState newState = this.detector.resetState(AbstractIntegratedPropagator.this.getCompleteState(t, y));
                AbstractIntegratedPropagator.this.stateMapper.mapStateToArray(newState, y);
                EquationsMapper[] em = AbstractIntegratedPropagator.this.mathODE.getSecondaryMappers();
                for (int i = 0; i < AbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                    double[] secondary = newState.getAdditionalState(((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName());
                    System.arraycopy(secondary, 0, y, em[i].getFirstIndex(), secondary.length);
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class ConvertedSecondaryStateEquations
    implements SecondaryEquations {
        private final AdditionalEquations equations;
        private final int dimension;

        public ConvertedSecondaryStateEquations(AdditionalEquations equations, int dimension) {
            this.equations = equations;
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void computeDerivatives(double t, double[] primary, double[] primaryDot, double[] secondary, double[] secondaryDot) throws OrekitExceptionWrapper {
            try {
                SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, primary, true);
                currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
                currentState = currentState.addAdditionalState(this.equations.getName(), secondary);
                double[] additionalMainDot = this.equations.computeDerivatives(currentState, secondaryDot);
                if (additionalMainDot != null) {
                    for (int i = 0; i < additionalMainDot.length; ++i) {
                        int n = i;
                        primaryDot[n] = primaryDot[n] + additionalMainDot[i];
                    }
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class ConvertedMainStateEquations
    implements FirstOrderDifferentialEquations {
        private final MainStateEquations main;

        public ConvertedMainStateEquations(MainStateEquations main) {
            this.main = main;
            AbstractIntegratedPropagator.this.calls = 0;
        }

        public int getDimension() {
            return AbstractIntegratedPropagator.this.getBasicDimension();
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) throws OrekitExceptionWrapper {
            try {
                SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, y, true);
                currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
                double[] mainDot = this.main.computeDerivatives(currentState);
                System.arraycopy(mainDot, 0, yDot, 0, mainDot.length);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
            ++AbstractIntegratedPropagator.this.calls;
        }
    }

    public static interface MainStateEquations {
        public double[] computeDerivatives(SpacecraftState var1) throws OrekitException;
    }
}

