/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.orekit.attitudes.Attitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.ParameterConfiguration;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class Jacobianizer {
    private final ForceModel forceModel;
    private final double mu;
    private double hPos;
    private final Map<String, Double> hParam;

    public Jacobianizer(ForceModel forceModel, double mu, Collection<ParameterConfiguration> paramsAndSteps, double hPos) {
        this.forceModel = forceModel;
        this.mu = mu;
        this.hParam = new HashMap<String, Double>();
        this.hPos = hPos;
        for (ParameterConfiguration param : paramsAndSteps) {
            String name = param.getParameterName();
            if (!forceModel.isSupported(name)) continue;
            double step = param.getHP();
            if (Double.isNaN(step)) {
                step = FastMath.max((double)1.0, (double)FastMath.abs((double)forceModel.getParameter(name))) * FastMath.sqrt((double)Precision.EPSILON);
            }
            this.hParam.put(name, step);
        }
    }

    private void computeShiftedAcceleration(AccelerationRetriever retriever, AbsoluteDate date, Frame frame, Vector3D position, Vector3D velocity, Rotation rotation, double mass) throws OrekitException {
        CartesianOrbit shiftedORbit = new CartesianOrbit(new PVCoordinates(position, velocity), frame, date, this.mu);
        retriever.setOrbit(shiftedORbit);
        this.forceModel.addContribution(new SpacecraftState((Orbit)shiftedORbit, new Attitude(date, frame, rotation, Vector3D.ZERO, Vector3D.ZERO), mass), retriever);
    }

    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        double[] derM;
        int parameters = mass.getFreeParameters();
        int order = mass.getOrder();
        Vector3D p0 = position.toVector3D();
        Vector3D v0 = velocity.toVector3D();
        double r2 = p0.getNormSq();
        double hVel = this.mu * this.hPos / (v0.getNorm() * r2);
        double hMass = mass.getValue() * this.hPos / FastMath.sqrt((double)r2);
        AccelerationRetriever nominal = new AccelerationRetriever();
        this.computeShiftedAcceleration(nominal, date, frame, p0, v0, rotation.toRotation(), mass.getValue());
        double[] a0 = nominal.getAcceleration().toArray();
        AccelerationRetriever shifted = new AccelerationRetriever();
        this.computeShiftedAcceleration(shifted, date, frame, this.shift(position, 0, this.hPos), v0, this.shift(rotation, 0, this.hPos), this.shift(mass, 0, this.hPos));
        double[] derPx = new Vector3D(1.0 / this.hPos, shifted.getAcceleration(), -1.0 / this.hPos, nominal.getAcceleration()).toArray();
        this.computeShiftedAcceleration(shifted, date, frame, this.shift(position, 1, this.hPos), v0, this.shift(rotation, 1, this.hPos), this.shift(mass, 1, this.hPos));
        double[] derPy = new Vector3D(1.0 / this.hPos, shifted.getAcceleration(), -1.0 / this.hPos, nominal.getAcceleration()).toArray();
        this.computeShiftedAcceleration(shifted, date, frame, this.shift(position, 2, this.hPos), v0, this.shift(rotation, 2, this.hPos), this.shift(mass, 2, this.hPos));
        double[] derPz = new Vector3D(1.0 / this.hPos, shifted.getAcceleration(), -1.0 / this.hPos, nominal.getAcceleration()).toArray();
        this.computeShiftedAcceleration(shifted, date, frame, p0, this.shift(velocity, 3, hVel), this.shift(rotation, 3, hVel), this.shift(mass, 3, hVel));
        double[] derVx = new Vector3D(1.0 / hVel, shifted.getAcceleration(), -1.0 / hVel, nominal.getAcceleration()).toArray();
        this.computeShiftedAcceleration(shifted, date, frame, p0, this.shift(velocity, 4, hVel), this.shift(rotation, 4, hVel), this.shift(mass, 4, hVel));
        double[] derVy = new Vector3D(1.0 / hVel, shifted.getAcceleration(), -1.0 / hVel, nominal.getAcceleration()).toArray();
        this.computeShiftedAcceleration(shifted, date, frame, p0, this.shift(velocity, 5, hVel), this.shift(rotation, 5, hVel), this.shift(mass, 5, hVel));
        double[] derVz = new Vector3D(1.0 / hVel, shifted.getAcceleration(), -1.0 / hVel, nominal.getAcceleration()).toArray();
        if (parameters < 7) {
            derM = null;
        } else {
            this.computeShiftedAcceleration(shifted, date, frame, p0, v0, this.shift(rotation, 6, hMass), this.shift(mass, 6, hMass));
            derM = new Vector3D(1.0 / hMass, shifted.getAcceleration(), -1.0 / hMass, nominal.getAcceleration()).toArray();
        }
        double[] derivatives = new double[1 + parameters];
        DerivativeStructure[] accDer = new DerivativeStructure[3];
        for (int i = 0; i < 3; ++i) {
            derivatives[0] = a0[i];
            derivatives[1] = derPx[i];
            derivatives[2] = derPy[i];
            derivatives[3] = derPz[i];
            derivatives[4] = derVx[i];
            derivatives[5] = derVy[i];
            derivatives[6] = derVz[i];
            if (derM != null) {
                derivatives[7] = derM[i];
            }
            accDer[i] = new DerivativeStructure(parameters, order, derivatives);
        }
        return new FieldVector3D((RealFieldElement[])accDer);
    }

    private Vector3D shift(FieldVector3D<DerivativeStructure> nominal, int index, double h) {
        double[] delta = new double[((DerivativeStructure)nominal.getX()).getFreeParameters()];
        delta[index] = h;
        return new Vector3D(((DerivativeStructure)nominal.getX()).taylor(delta), ((DerivativeStructure)nominal.getY()).taylor(delta), ((DerivativeStructure)nominal.getZ()).taylor(delta));
    }

    private Rotation shift(FieldRotation<DerivativeStructure> nominal, int index, double h) {
        double[] delta = new double[((DerivativeStructure)nominal.getQ0()).getFreeParameters()];
        delta[index] = h;
        return new Rotation(((DerivativeStructure)nominal.getQ0()).taylor(delta), ((DerivativeStructure)nominal.getQ1()).taylor(delta), ((DerivativeStructure)nominal.getQ2()).taylor(delta), ((DerivativeStructure)nominal.getQ3()).taylor(delta), true);
    }

    private double shift(DerivativeStructure nominal, int index, double h) {
        double[] delta = new double[nominal.getFreeParameters()];
        delta[index] = h;
        return nominal.taylor(delta);
    }

    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        if (!this.hParam.containsKey(paramName)) {
            StringBuilder builder = new StringBuilder();
            for (String available : this.hParam.keySet()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(available);
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, builder.toString());
        }
        double hP = this.hParam.get(paramName);
        AccelerationRetriever nominal = new AccelerationRetriever();
        nominal.setOrbit(s.getOrbit());
        this.forceModel.addContribution(s, nominal);
        double nx = nominal.getAcceleration().getX();
        double ny = nominal.getAcceleration().getY();
        double nz = nominal.getAcceleration().getZ();
        double paramValue = this.forceModel.getParameter(paramName);
        this.forceModel.setParameter(paramName, paramValue + hP);
        AccelerationRetriever shifted = new AccelerationRetriever();
        shifted.setOrbit(s.getOrbit());
        this.forceModel.addContribution(s, shifted);
        double sx = shifted.getAcceleration().getX();
        double sy = shifted.getAcceleration().getY();
        double sz = shifted.getAcceleration().getZ();
        this.forceModel.setParameter(paramName, paramValue);
        return new FieldVector3D((RealFieldElement)new DerivativeStructure(1, 1, new double[]{nx, (sx - nx) / hP}), (RealFieldElement)new DerivativeStructure(1, 1, new double[]{ny, (sy - ny) / hP}), (RealFieldElement)new DerivativeStructure(1, 1, new double[]{nz, (sz - nz) / hP}));
    }

    private static class AccelerationRetriever
    implements TimeDerivativesEquations {
        private Vector3D acceleration = Vector3D.ZERO;
        private Orbit orbit = null;

        protected AccelerationRetriever() {
        }

        public Vector3D getAcceleration() {
            return this.acceleration;
        }

        public void setOrbit(Orbit orbit) {
            this.acceleration = Vector3D.ZERO;
            this.orbit = orbit;
        }

        @Override
        public void addKeplerContribution(double mu) {
            Vector3D position = this.orbit.getPVCoordinates().getPosition();
            double r2 = position.getNormSq();
            this.acceleration = this.acceleration.subtract(mu / (r2 * FastMath.sqrt((double)r2)), (Vector)position);
        }

        @Override
        public void addXYZAcceleration(double x, double y, double z) {
            this.acceleration = this.acceleration.add((Vector)new Vector3D(x, y, z));
        }

        @Override
        public void addAcceleration(Vector3D gamma, Frame frame) throws OrekitException {
            Transform t = frame.getTransformTo(this.orbit.getFrame(), this.orbit.getDate());
            Vector3D gammInRefFrame = t.transformVector(gamma);
            this.addXYZAcceleration(gammInRefFrame.getX(), gammInRefFrame.getY(), gammInRefFrame.getZ());
        }

        @Override
        public void addMassDerivative(double q) {
        }
    }
}

