/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;

public class JacobiansMapper {
    private String name;
    private final int stateDimension;
    private final int parameters;
    private final OrbitType orbitType;
    private final PositionAngle angleType;

    JacobiansMapper(String name, int stateDimension, int parameters, OrbitType orbitType, PositionAngle angleType) {
        this.name = name;
        this.stateDimension = stateDimension;
        this.parameters = parameters;
        this.orbitType = orbitType;
        this.angleType = angleType;
    }

    public String getName() {
        return this.name;
    }

    public int getAdditionalStateDimension() {
        return this.stateDimension * (this.stateDimension + this.parameters);
    }

    public int getStateDimension() {
        return this.stateDimension;
    }

    public int getParameters() {
        return this.parameters;
    }

    private double[][] getdYdC(SpacecraftState state) {
        double[][] dYdC = new double[this.stateDimension][this.stateDimension];
        Orbit orbit = this.orbitType.convertType(state.getOrbit());
        orbit.getJacobianWrtCartesian(this.angleType, dYdC);
        for (int i = 6; i < this.stateDimension; ++i) {
            dYdC[i][i] = 1.0;
        }
        return dYdC;
    }

    void setInitialJacobians(SpacecraftState state, double[][] dY1dY0, double[][] dY1dP, double[] p) {
        Array2DRowRealMatrix dY1dC1 = new Array2DRowRealMatrix(this.getdYdC(state), false);
        DecompositionSolver solver = new QRDecomposition((RealMatrix)dY1dC1).getSolver();
        RealMatrix dC1dY0 = solver.solve((RealMatrix)new Array2DRowRealMatrix(dY1dY0, false));
        int index = 0;
        for (int i = 0; i < this.stateDimension; ++i) {
            for (int j = 0; j < this.stateDimension; ++j) {
                p[index++] = dC1dY0.getEntry(i, j);
            }
        }
        if (this.parameters > 0) {
            RealMatrix dC1dP = solver.solve((RealMatrix)new Array2DRowRealMatrix(dY1dP, false));
            for (int i = 0; i < this.stateDimension; ++i) {
                for (int j = 0; j < this.parameters; ++j) {
                    p[index++] = dC1dP.getEntry(i, j);
                }
            }
        }
    }

    public void getStateJacobian(SpacecraftState state, double[][] dYdY0) throws OrekitException {
        double[][] dYdC = this.getdYdC(state);
        double[] p = state.getAdditionalState(this.name);
        for (int i = 0; i < this.stateDimension; ++i) {
            double[] rowC = dYdC[i];
            double[] rowD = dYdY0[i];
            for (int j = 0; j < this.stateDimension; ++j) {
                double sum = 0.0;
                int pIndex = j;
                for (int k = 0; k < this.stateDimension; ++k) {
                    sum += rowC[k] * p[pIndex];
                    pIndex += this.stateDimension;
                }
                rowD[j] = sum;
            }
        }
    }

    public void getParametersJacobian(SpacecraftState state, double[][] dYdP) throws OrekitException {
        if (this.parameters > 0) {
            double[][] dYdC = this.getdYdC(state);
            double[] p = state.getAdditionalState(this.name);
            for (int i = 0; i < this.stateDimension; ++i) {
                double[] rowC = dYdC[i];
                double[] rowD = dYdP[i];
                for (int j = 0; j < this.parameters; ++j) {
                    double sum = 0.0;
                    int pIndex = j + this.stateDimension * this.stateDimension;
                    for (int k = 0; k < this.stateDimension; ++k) {
                        sum += rowC[k] * p[pIndex];
                        pIndex += this.parameters;
                    }
                    rowD[j] = sum;
                }
            }
        }
    }
}

