/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.TesseralContribution;
import org.orekit.propagation.semianalytical.dsst.forces.ZonalContribution;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.time.AbsoluteDate;

public class DSSTCentralBody
implements DSSTForceModel {
    private final ZonalContribution zonal;
    private final TesseralContribution tesseral;

    public DSSTCentralBody(Frame centralBodyFrame, double centralBodyRotationRate, UnnormalizedSphericalHarmonicsProvider provider, boolean mDailiesOnly) {
        this.zonal = new ZonalContribution(provider);
        this.tesseral = provider.getMaxOrder() == 0 ? null : new TesseralContribution(centralBodyFrame, centralBodyRotationRate, provider, mDailiesOnly);
    }

    public DSSTCentralBody(Frame centralBodyFrame, double centralBodyRotationRate, UnnormalizedSphericalHarmonicsProvider provider) {
        this(centralBodyFrame, centralBodyRotationRate, provider, false);
    }

    @Override
    public void initialize(AuxiliaryElements aux, boolean meanOnly) throws OrekitException {
        this.zonal.initialize(aux, meanOnly);
        if (this.tesseral != null) {
            this.tesseral.initialize(aux, meanOnly);
        }
    }

    @Override
    public void initializeStep(AuxiliaryElements aux) throws OrekitException {
        this.zonal.initializeStep(aux);
        if (this.tesseral != null) {
            this.tesseral.initializeStep(aux);
        }
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState spacecraftState) throws OrekitException {
        double[] meanElementRate = this.zonal.getMeanElementRate(spacecraftState);
        if (this.tesseral != null) {
            double[] tesseralMeanRate = this.tesseral.getMeanElementRate(spacecraftState);
            for (int i = 0; i < 6; ++i) {
                int n = i;
                meanElementRate[n] = meanElementRate[n] + tesseralMeanRate[i];
            }
        }
        return meanElementRate;
    }

    @Override
    public double[] getShortPeriodicVariations(AbsoluteDate date, double[] meanElements) throws OrekitException {
        double[] shortPeriodics = this.zonal.getShortPeriodicVariations(date, meanElements);
        if (this.tesseral != null) {
            double[] tesseralShort = this.tesseral.getShortPeriodicVariations(date, meanElements);
            for (int i = 0; i < 6; ++i) {
                int n = i;
                shortPeriodics[n] = shortPeriodics[n] + tesseralShort[i];
            }
        }
        return shortPeriodics;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public void computeShortPeriodicsCoefficients(SpacecraftState state) throws OrekitException {
        this.zonal.computeShortPeriodicsCoefficients(state);
        if (this.tesseral != null) {
            this.tesseral.computeShortPeriodicsCoefficients(state);
        }
    }

    @Override
    public void resetShortPeriodicsCoefficients() {
        this.zonal.resetShortPeriodicsCoefficients();
        if (this.tesseral != null) {
            this.tesseral.resetShortPeriodicsCoefficients();
        }
    }

    public UnnormalizedSphericalHarmonicsProvider getProvider() {
        return this.zonal.getProvider();
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider provider) {
    }
}

