/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;

public class GammaMnsFunction {
    private final Map<CoefficientsFactory.MNSKey, Double> map;
    private final double[] fact;
    private final double opIg;
    private final int I;

    public GammaMnsFunction(double[] fact, double gamma, int I) {
        this.fact = (double[])fact.clone();
        this.opIg = 1.0 + (double)I * gamma;
        this.I = I;
        this.map = new TreeMap<CoefficientsFactory.MNSKey, Double>();
    }

    public double getValue(int m, int n, int s) {
        double res = 0.0;
        CoefficientsFactory.MNSKey key = new CoefficientsFactory.MNSKey(m, n, s);
        if (this.map.containsKey(key)) {
            res = this.map.get(key);
        } else {
            if (s <= -m) {
                res = FastMath.pow((double)-1.0, (int)(m - s)) * FastMath.pow((double)2.0, (int)s) * FastMath.pow((double)this.opIg, (int)(-this.I * m));
            } else if (s >= m) {
                res = FastMath.pow((double)2.0, (int)(-s)) * FastMath.pow((double)this.opIg, (int)(this.I * m));
            } else {
                res = FastMath.pow((double)-1.0, (int)(m - s)) * FastMath.pow((double)2.0, (int)(-m)) * FastMath.pow((double)this.opIg, (int)(this.I * s));
                res *= this.fact[n + m] * this.fact[n - m];
                res /= this.fact[n + s] * this.fact[n - s];
            }
            this.map.put(key, res);
        }
        return res;
    }

    public double getDerivative(int m, int n, int s) {
        double res = 0.0;
        res = s <= -m ? (double)(-m * this.I) * this.getValue(m, n, s) / this.opIg : (s >= m ? (double)(m * this.I) * this.getValue(m, n, s) / this.opIg : (double)(s * this.I) * this.getValue(m, n, s) / this.opIg);
        return res;
    }
}

