/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.apache.commons.math3.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UT1Scale;

public class GMSTScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static double FULL_DAY = 86400.0;
    private static double HALF_DAY = 43200.0;
    private static double C0 = 24110.54841;
    private static double C1 = 8640184.812866;
    private static double C2 = 0.093104;
    private static double C3 = -6.2E-6;
    private final UT1Scale ut1;
    private final AbsoluteDate referenceDate;

    GMSTScale(UT1Scale ut1) {
        this.ut1 = ut1;
        this.referenceDate = new AbsoluteDate(2000, 1, 1, 12, 0, 0.0, (TimeScale)ut1);
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        double ts = date.durationFrom(this.referenceDate);
        double tc = ts / 3.15576E9;
        double gmst0h = C0 + tc * (C1 + tc * (C2 + tc * C3));
        double offset = gmst0h + this.ut1.offsetFromTAI(date);
        return offset - FULL_DAY * FastMath.floor((double)((offset + HALF_DAY) / FULL_DAY));
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        AbsoluteDate reference = new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getTAI());
        double offset = 0.0;
        for (int i = 0; i < 8; ++i) {
            offset = -this.offsetFromTAI(reference.shiftedBy(offset));
        }
        return offset;
    }

    @Override
    public String getName() {
        return "GMST";
    }

    public String toString() {
        return this.getName();
    }
}

