/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class TimeComponents
implements Serializable,
Comparable<TimeComponents> {
    public static final TimeComponents H00 = new TimeComponents(0, 0, 0.0);
    public static final TimeComponents H12 = new TimeComponents(12, 0, 0.0);
    private static final long serialVersionUID = -8566834296299377436L;
    private static final DecimalFormat TWO_DIGITS = new DecimalFormat("00");
    private static final DecimalFormat SECONDS_FORMAT = new DecimalFormat("00.000", new DecimalFormatSymbols(Locale.US));
    private static Pattern ISO8601_FORMATS = Pattern.compile("^(\\d\\d):?(\\d\\d):?(\\d\\d(?:[.,]\\d+)?)?(?:Z|[-+]00(?::00)?)?$");
    private final int hour;
    private final int minute;
    private final double second;

    public TimeComponents(int hour, int minute, double second) throws IllegalArgumentException {
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0.0 || second >= 61.0) {
            throw OrekitException.createIllegalArgumentException(OrekitMessages.NON_EXISTENT_HMS_TIME, hour, minute, second);
        }
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public TimeComponents(double secondInDay) {
        this(0, secondInDay);
    }

    public TimeComponents(int secondInDayA, double secondInDayB) {
        int carry = (int)FastMath.floor((double)secondInDayB);
        int wholeSeconds = secondInDayA + carry;
        double fractional = secondInDayB - (double)carry;
        if (wholeSeconds < 0 || wholeSeconds > 86400) {
            throw OrekitException.createIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_SECONDS_NUMBER, wholeSeconds);
        }
        this.hour = wholeSeconds / 3600;
        this.minute = (wholeSeconds -= 3600 * this.hour) / 60;
        this.second = (double)(wholeSeconds -= 60 * this.minute) + fractional;
    }

    public static TimeComponents parseTime(String string) {
        Matcher timeMatcher = ISO8601_FORMATS.matcher(string);
        if (timeMatcher.matches()) {
            return new TimeComponents(Integer.parseInt(timeMatcher.group(1)), Integer.parseInt(timeMatcher.group(2)), Double.parseDouble(timeMatcher.group(3).replace(',', '.')));
        }
        throw OrekitException.createIllegalArgumentException(OrekitMessages.NON_EXISTENT_TIME, string);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public double getSecond() {
        return this.second;
    }

    public double getSecondsInDay() {
        return this.second + (double)(60 * this.minute) + (double)(3600 * this.hour);
    }

    public String toString() {
        return new StringBuffer().append(TWO_DIGITS.format(this.hour)).append(':').append(TWO_DIGITS.format(this.minute)).append(':').append(SECONDS_FORMAT.format(this.second)).toString();
    }

    @Override
    public int compareTo(TimeComponents other) {
        double otherSeconds;
        double seconds = this.getSecondsInDay();
        if (seconds < (otherSeconds = other.getSecondsInDay())) {
            return -1;
        }
        if (seconds > otherSeconds) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        try {
            TimeComponents otherTime = (TimeComponents)other;
            return otherTime != null && this.hour == otherTime.hour && this.minute == otherTime.minute && this.second == otherTime.second;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.second);
        return this.hour << 16 ^ this.minute << 8 ^ (int)(bits ^ bits >>> 32);
    }
}

