/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collection;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.interpolation.FieldHermiteInterpolator;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldAngularCoordinates;

public class TimeStampedFieldAngularCoordinates<T extends RealFieldElement<T>>
extends FieldAngularCoordinates<T>
implements TimeStamped {
    private static final long serialVersionUID = 20140723L;
    private final AbsoluteDate date;

    public TimeStampedFieldAngularCoordinates(AbsoluteDate date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        super(rotation, rotationRate, rotationAcceleration);
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> revert() {
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.getRotation().revert(), this.getRotation().applyInverseTo(this.getRotationRate().negate()), this.getRotation().applyInverseTo(this.getRotationAcceleration().negate()));
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> shiftedBy(double dt) {
        TimeShiftable sac = super.shiftedBy(dt);
        return new TimeStampedFieldAngularCoordinates(this.date.shiftedBy(dt), ((FieldAngularCoordinates)sac).getRotation(), ((FieldAngularCoordinates)sac).getRotationRate(), ((FieldAngularCoordinates)sac).getRotationAcceleration());
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D rOmega = this.getRotation().applyTo(offset.getRotationRate());
        FieldVector3D rOmegaDot = this.getRotation().applyTo(offset.getRotationAcceleration());
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.getRotation().applyTo(offset.getRotation()), this.getRotationRate().add(rOmega), new FieldVector3D(1.0, this.getRotationAcceleration(), 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.getRotationRate(), (FieldVector3D)rOmega)));
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset((FieldAngularCoordinates)offset.revert());
    }

    public static <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> interpolate(AbsoluteDate date, AngularDerivativesFilter filter, Collection<TimeStampedFieldAngularCoordinates<T>> sample) throws OrekitException {
        FieldVector3D meanRate;
        FieldVector3D sum;
        Field field = sample.iterator().next().getRotation().getQ0().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement one = (RealFieldElement)field.getOne();
        double epsilon = Math.PI * 2 / (double)sample.size();
        double threshold = FastMath.min((double)-0.9999, (double)(-FastMath.cos((double)(epsilon / 4.0))));
        if (filter != AngularDerivativesFilter.USE_R) {
            sum = new FieldVector3D(zero, zero, zero);
            for (TimeStampedFieldAngularCoordinates<T> datedAC : sample) {
                sum = sum.add(datedAC.getRotationRate());
            }
            meanRate = new FieldVector3D(1.0 / (double)sample.size(), sum);
        } else {
            if (sample.size() < 2) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, sample.size());
            }
            sum = new FieldVector3D(zero, zero, zero);
            TimeStampedFieldAngularCoordinates<T> previous = null;
            for (TimeStampedFieldAngularCoordinates<T> datedAC : sample) {
                if (previous != null) {
                    sum = sum.add(TimeStampedFieldAngularCoordinates.estimateRate(previous.getRotation(), datedAC.getRotation(), datedAC.date.durationFrom(previous.getDate())));
                }
                previous = datedAC;
            }
            meanRate = new FieldVector3D(1.0 / (double)(sample.size() - 1), sum);
        }
        FieldAngularCoordinates offset = new TimeStampedFieldAngularCoordinates<T>(date, new FieldRotation(one, zero, zero, zero, false), meanRate, new FieldVector3D(zero, zero, zero));
        boolean restart = true;
        for (int i = 0; restart && i < sample.size() + 2; ++i) {
            restart = false;
            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
            double[] previous = new double[]{1.0, 0.0, 0.0, 0.0};
            block8: for (TimeStampedFieldAngularCoordinates<T> ac : sample) {
                RealFieldElement dt;
                FieldAngularCoordinates fixed = ac.subtractOffset(offset.shiftedBy((dt = (RealFieldElement)zero.add(ac.date.durationFrom(date))).getReal()));
                RealFieldElement[][] rodrigues = TimeStampedFieldAngularCoordinates.getModifiedRodrigues((TimeStampedFieldAngularCoordinates)fixed, (double[])previous, (double)threshold);
                if (rodrigues == null) {
                    restart = true;
                    break;
                }
                switch (filter) {
                    case USE_RRA: {
                        interpolator.addSamplePoint((FieldElement)dt, (FieldElement[][])new RealFieldElement[][]{rodrigues[0], rodrigues[1], rodrigues[2]});
                        continue block8;
                    }
                    case USE_RR: {
                        interpolator.addSamplePoint((FieldElement)dt, (FieldElement[][])new RealFieldElement[][]{rodrigues[0], rodrigues[1]});
                        continue block8;
                    }
                    case USE_R: {
                        interpolator.addSamplePoint((FieldElement)dt, (FieldElement[][])new RealFieldElement[][]{rodrigues[0]});
                        continue block8;
                    }
                }
                throw OrekitException.createInternalError(null);
            }
            if (!restart) {
                RealFieldElement[][] p = (RealFieldElement[][])interpolator.derivatives((FieldElement)field.getZero(), 2);
                return TimeStampedFieldAngularCoordinates.createFromModifiedRodrigues((RealFieldElement[][])p, offset);
            }
            offset = offset.addOffset(new FieldAngularCoordinates(new FieldRotation(new FieldVector3D(one, zero, zero), (RealFieldElement)zero.add(epsilon)), new FieldVector3D(zero, zero, zero), new FieldVector3D(zero, zero, zero)));
        }
        throw OrekitException.createInternalError(null);
    }

    private static <T extends RealFieldElement<T>> T[] array6(Field<T> field, T a0, T a1, T a2, T a3, T a4, T a5) {
        RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(field, (int)6);
        array[0] = a0;
        array[1] = a1;
        array[2] = a2;
        array[3] = a3;
        array[4] = a4;
        array[5] = a5;
        return array;
    }

    private static <T extends RealFieldElement<T>> T[][] matrix33(Field<T> field, T a00, T a01, T a02, T a10, T a11, T a12, T a20, T a21, T a22) {
        RealFieldElement[][] matrix = (RealFieldElement[][])MathArrays.buildArray(field, (int)3, (int)3);
        matrix[0][0] = a00;
        matrix[0][1] = a01;
        matrix[0][2] = a02;
        matrix[1][0] = a10;
        matrix[1][1] = a11;
        matrix[1][2] = a12;
        matrix[2][0] = a20;
        matrix[2][1] = a21;
        matrix[2][2] = a22;
        return matrix;
    }

    private static <T extends RealFieldElement<T>> T[][] getModifiedRodrigues(TimeStampedFieldAngularCoordinates<T> fixed, double[] previous, double threshold) {
        RealFieldElement q0 = fixed.getRotation().getQ0();
        RealFieldElement q1 = fixed.getRotation().getQ1();
        RealFieldElement q2 = fixed.getRotation().getQ2();
        RealFieldElement q3 = fixed.getRotation().getQ3();
        if (MathArrays.linearCombination((double)q0.getReal(), (double)previous[0], (double)q1.getReal(), (double)previous[1], (double)q2.getReal(), (double)previous[2], (double)q3.getReal(), (double)previous[3]) < 0.0) {
            q0 = (RealFieldElement)q0.negate();
            q1 = (RealFieldElement)q1.negate();
            q2 = (RealFieldElement)q2.negate();
            q3 = (RealFieldElement)q3.negate();
        }
        previous[0] = q0.getReal();
        previous[1] = q1.getReal();
        previous[2] = q2.getReal();
        previous[3] = q3.getReal();
        if (q0.getReal() < threshold) {
            return null;
        }
        Field field = q0.getField();
        RealFieldElement oX = fixed.getRotationRate().getX();
        RealFieldElement oY = fixed.getRotationRate().getY();
        RealFieldElement oZ = fixed.getRotationRate().getZ();
        RealFieldElement oXDot = fixed.getRotationAcceleration().getX();
        RealFieldElement oYDot = fixed.getRotationAcceleration().getY();
        RealFieldElement oZDot = fixed.getRotationAcceleration().getZ();
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), (Object)oX, q2.negate(), (Object)oY, q3.negate(), (Object)oZ)).multiply(0.5);
        RealFieldElement q1Dot = (RealFieldElement)((RealFieldElement)q1.linearCombination((Object)q0, (Object)oX, q3.negate(), (Object)oY, (Object)q2, (Object)oZ)).multiply(0.5);
        RealFieldElement q2Dot = (RealFieldElement)((RealFieldElement)q2.linearCombination((Object)q3, (Object)oX, (Object)q0, (Object)oY, q1.negate(), (Object)oZ)).multiply(0.5);
        RealFieldElement q3Dot = (RealFieldElement)((RealFieldElement)q3.linearCombination(q2.negate(), (Object)oX, (Object)q1, (Object)oY, (Object)q0, (Object)oZ)).multiply(0.5);
        RealFieldElement q0DotDot = (RealFieldElement)((RealFieldElement)q0.linearCombination((Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)q1, (RealFieldElement)q2, (RealFieldElement)q3, (RealFieldElement)q1Dot, (RealFieldElement)q2Dot, (RealFieldElement)q3Dot), (Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)oXDot, (RealFieldElement)oYDot, (RealFieldElement)oZDot, (RealFieldElement)oX, (RealFieldElement)oY, (RealFieldElement)oZ))).multiply(-0.5);
        RealFieldElement q1DotDot = (RealFieldElement)((RealFieldElement)q1.linearCombination((Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)q0, (RealFieldElement)q2, (RealFieldElement)((RealFieldElement)q3.negate()), (RealFieldElement)q0Dot, (RealFieldElement)q2Dot, (RealFieldElement)((RealFieldElement)q3Dot.negate())), (Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)oXDot, (RealFieldElement)oZDot, (RealFieldElement)oYDot, (RealFieldElement)oX, (RealFieldElement)oZ, (RealFieldElement)oY))).multiply(0.5);
        RealFieldElement q2DotDot = (RealFieldElement)((RealFieldElement)q2.linearCombination((Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)q0, (RealFieldElement)q3, (RealFieldElement)((RealFieldElement)q1.negate()), (RealFieldElement)q0Dot, (RealFieldElement)q3Dot, (RealFieldElement)((RealFieldElement)q1Dot.negate())), (Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)oYDot, (RealFieldElement)oXDot, (RealFieldElement)oZDot, (RealFieldElement)oY, (RealFieldElement)oX, (RealFieldElement)oZ))).multiply(0.5);
        RealFieldElement q3DotDot = (RealFieldElement)((RealFieldElement)q3.linearCombination((Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)q0, (RealFieldElement)q1, (RealFieldElement)((RealFieldElement)q2.negate()), (RealFieldElement)q0Dot, (RealFieldElement)q1Dot, (RealFieldElement)((RealFieldElement)q2Dot.negate())), (Object[])TimeStampedFieldAngularCoordinates.array6((Field)field, (RealFieldElement)oZDot, (RealFieldElement)oYDot, (RealFieldElement)oXDot, (RealFieldElement)oZ, (RealFieldElement)oY, (RealFieldElement)oX))).multiply(0.5);
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)q0.add(1.0)).reciprocal();
        RealFieldElement mTwoInvQ0Dot = (RealFieldElement)((RealFieldElement)inv.multiply((Object)q0Dot)).multiply(-2);
        RealFieldElement r1 = (RealFieldElement)inv.multiply((Object)q1);
        RealFieldElement r2 = (RealFieldElement)inv.multiply((Object)q2);
        RealFieldElement r3 = (RealFieldElement)inv.multiply((Object)q3);
        RealFieldElement mInvR1 = (RealFieldElement)((RealFieldElement)inv.multiply((Object)r1)).negate();
        RealFieldElement mInvR2 = (RealFieldElement)((RealFieldElement)inv.multiply((Object)r2)).negate();
        RealFieldElement mInvR3 = (RealFieldElement)((RealFieldElement)inv.multiply((Object)r3)).negate();
        RealFieldElement r1Dot = (RealFieldElement)r1.linearCombination((Object)inv, (Object)q1Dot, (Object)mInvR1, (Object)q0Dot);
        RealFieldElement r2Dot = (RealFieldElement)r2.linearCombination((Object)inv, (Object)q2Dot, (Object)mInvR2, (Object)q0Dot);
        RealFieldElement r3Dot = (RealFieldElement)r3.linearCombination((Object)inv, (Object)q3Dot, (Object)mInvR3, (Object)q0Dot);
        RealFieldElement r1DotDot = (RealFieldElement)r1.linearCombination((Object)inv, (Object)q1DotDot, (Object)mTwoInvQ0Dot, (Object)r1Dot, (Object)mInvR1, (Object)q0DotDot);
        RealFieldElement r2DotDot = (RealFieldElement)r2.linearCombination((Object)inv, (Object)q2DotDot, (Object)mTwoInvQ0Dot, (Object)r2Dot, (Object)mInvR2, (Object)q0DotDot);
        RealFieldElement r3DotDot = (RealFieldElement)r3.linearCombination((Object)inv, (Object)q3DotDot, (Object)mTwoInvQ0Dot, (Object)r3Dot, (Object)mInvR3, (Object)q0DotDot);
        return TimeStampedFieldAngularCoordinates.matrix33((Field)field, (RealFieldElement)r1, (RealFieldElement)r2, (RealFieldElement)r3, (RealFieldElement)r1Dot, (RealFieldElement)r2Dot, (RealFieldElement)r3Dot, (RealFieldElement)r1DotDot, (RealFieldElement)r2DotDot, (RealFieldElement)r3DotDot);
    }

    private static <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> createFromModifiedRodrigues(T[][] r, TimeStampedFieldAngularCoordinates<T> offset) {
        RealFieldElement rSquared = (RealFieldElement)((RealFieldElement)((RealFieldElement)r[0][0].multiply(r[0][0])).add(r[0][1].multiply(r[0][1]))).add(r[0][2].multiply(r[0][2]));
        RealFieldElement oPQ0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)rSquared.add(1.0)).reciprocal()).multiply(2);
        RealFieldElement q0 = (RealFieldElement)oPQ0.subtract(1.0);
        RealFieldElement q1 = (RealFieldElement)oPQ0.multiply(r[0][0]);
        RealFieldElement q2 = (RealFieldElement)oPQ0.multiply(r[0][1]);
        RealFieldElement q3 = (RealFieldElement)oPQ0.multiply(r[0][2]);
        RealFieldElement oPQ02 = (RealFieldElement)oPQ0.multiply((Object)oPQ0);
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)oPQ02.negate()).multiply(q0.linearCombination(r[0][0], r[1][0], r[0][1], r[1][1], r[0][2], r[1][2]));
        RealFieldElement q1Dot = (RealFieldElement)((RealFieldElement)oPQ0.multiply(r[1][0])).add(r[0][0].multiply((Object)q0Dot));
        RealFieldElement q2Dot = (RealFieldElement)((RealFieldElement)oPQ0.multiply(r[1][1])).add(r[0][1].multiply((Object)q0Dot));
        RealFieldElement q3Dot = (RealFieldElement)((RealFieldElement)oPQ0.multiply(r[1][2])).add(r[0][2].multiply((Object)q0Dot));
        RealFieldElement oX = (RealFieldElement)((RealFieldElement)q1.linearCombination(q1.negate(), (Object)q0Dot, (Object)q0, (Object)q1Dot, (Object)q3, (Object)q2Dot, q2.negate(), (Object)q3Dot)).multiply(2);
        RealFieldElement oY = (RealFieldElement)((RealFieldElement)q2.linearCombination(q2.negate(), (Object)q0Dot, q3.negate(), (Object)q1Dot, (Object)q0, (Object)q2Dot, (Object)q1, (Object)q3Dot)).multiply(2);
        RealFieldElement oZ = (RealFieldElement)((RealFieldElement)q3.linearCombination(q3.negate(), (Object)q0Dot, (Object)q2, (Object)q1Dot, q1.negate(), (Object)q2Dot, (Object)q0, (Object)q3Dot)).multiply(2);
        RealFieldElement q0DotDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)q0.getField().getOne()).subtract((Object)q0)).divide((Object)oPQ0)).multiply((Object)q0Dot)).multiply((Object)q0Dot)).subtract(oPQ02.multiply(q0.linearCombination(r[0][0], r[2][0], r[0][1], r[2][1], r[0][2], r[2][2])))).subtract(((RealFieldElement)((RealFieldElement)q1Dot.multiply((Object)q1Dot)).add(q2Dot.multiply((Object)q2Dot))).add(q3Dot.multiply((Object)q3Dot)));
        RealFieldElement q1DotDot = (RealFieldElement)q1.linearCombination((Object)oPQ0, r[2][0], r[1][0].multiply(2), (Object)q0Dot, r[0][0], (Object)q0DotDot);
        RealFieldElement q2DotDot = (RealFieldElement)q2.linearCombination((Object)oPQ0, r[2][1], r[1][1].multiply(2), (Object)q0Dot, r[0][1], (Object)q0DotDot);
        RealFieldElement q3DotDot = (RealFieldElement)q3.linearCombination((Object)oPQ0, r[2][2], r[1][2].multiply(2), (Object)q0Dot, r[0][2], (Object)q0DotDot);
        RealFieldElement oXDot = (RealFieldElement)((RealFieldElement)q1.linearCombination(q1.negate(), (Object)q0DotDot, (Object)q0, (Object)q1DotDot, (Object)q3, (Object)q2DotDot, q2.negate(), (Object)q3DotDot)).multiply(2);
        RealFieldElement oYDot = (RealFieldElement)((RealFieldElement)q2.linearCombination(q2.negate(), (Object)q0DotDot, q3.negate(), (Object)q1DotDot, (Object)q0, (Object)q2DotDot, (Object)q1, (Object)q3DotDot)).multiply(2);
        RealFieldElement oZDot = (RealFieldElement)((RealFieldElement)q3.linearCombination(q3.negate(), (Object)q0DotDot, (Object)q2, (Object)q1DotDot, q1.negate(), (Object)q2DotDot, (Object)q0, (Object)q3DotDot)).multiply(2);
        return new TimeStampedFieldAngularCoordinates<T>(offset.getDate(), new FieldRotation(q0, q1, q2, q3, false), new FieldVector3D(oX, oY, oZ), new FieldVector3D(oXDot, oYDot, oZDot)).addOffset((FieldAngularCoordinates)offset);
    }
}

