/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collection;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.interpolation.FieldHermiteInterpolator;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public class TimeStampedFieldPVCoordinates<T extends RealFieldElement<T>>
extends FieldPVCoordinates<T>
implements TimeStamped {
    private static final long serialVersionUID = 20140611L;
    private final AbsoluteDate date;

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        super(position, velocity, acceleration);
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a, FieldPVCoordinates<T> pv) {
        super(new FieldVector3D(a, pv.getPosition()), new FieldVector3D(a, pv.getVelocity()), new FieldVector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a, FieldPVCoordinates<T> pv) {
        super(new FieldVector3D(a, pv.getPosition()), new FieldVector3D(a, pv.getVelocity()), new FieldVector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a, PVCoordinates pv) {
        super(new FieldVector3D(a, pv.getPosition()), new FieldVector3D(a, pv.getVelocity()), new FieldVector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, FieldPVCoordinates<T> start, FieldPVCoordinates<T> end) {
        super(end.getPosition().subtract(start.getPosition()), end.getVelocity().subtract(start.getVelocity()), end.getAcceleration().subtract(start.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3, double a4, FieldPVCoordinates<T> pv4) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3, T a4, FieldPVCoordinates<T> pv4) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3, T a4, PVCoordinates pv4) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> shiftedBy(double dt) {
        TimeShiftable spv = super.shiftedBy(dt);
        return new TimeStampedFieldPVCoordinates(this.date.shiftedBy(dt), ((FieldPVCoordinates)spv).getPosition(), ((FieldPVCoordinates)spv).getVelocity(), ((FieldPVCoordinates)spv).getAcceleration());
    }

    public static <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> interpolate(AbsoluteDate date, CartesianDerivativesFilter filter, Collection<TimeStampedFieldPVCoordinates<T>> sample) {
        RealFieldElement prototype = sample.iterator().next().getPosition().getX();
        RealFieldElement zero = (RealFieldElement)prototype.getField().getZero();
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        switch (filter) {
            case USE_P: {
                for (TimeStampedFieldPVCoordinates<T> datedPV : sample) {
                    FieldVector3D position = datedPV.getPosition();
                    interpolator.addSamplePoint((FieldElement)zero.add(datedPV.getDate().durationFrom(date)), (FieldElement[][])new RealFieldElement[][]{position.toArray()});
                }
                break;
            }
            case USE_PV: {
                for (TimeStampedFieldPVCoordinates<T> datedPV : sample) {
                    FieldVector3D position = datedPV.getPosition();
                    FieldVector3D velocity = datedPV.getVelocity();
                    interpolator.addSamplePoint((FieldElement)zero.add(datedPV.getDate().durationFrom(date)), (FieldElement[][])new RealFieldElement[][]{position.toArray(), velocity.toArray()});
                }
                break;
            }
            case USE_PVA: {
                for (TimeStampedFieldPVCoordinates<T> datedPV : sample) {
                    FieldVector3D position = datedPV.getPosition();
                    FieldVector3D velocity = datedPV.getVelocity();
                    FieldVector3D acceleration = datedPV.getAcceleration();
                    interpolator.addSamplePoint((FieldElement)zero.add(datedPV.getDate().durationFrom(date)), (FieldElement[][])new RealFieldElement[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                }
                break;
            }
            default: {
                throw OrekitException.createInternalError(null);
            }
        }
        RealFieldElement[][] p = (RealFieldElement[][])interpolator.derivatives((FieldElement)zero, 2);
        return new TimeStampedFieldPVCoordinates<T>(date, new FieldVector3D(p[0]), new FieldVector3D(p[1]), new FieldVector3D(p[2]));
    }

    @Override
    public String toString() {
        String comma = ", ";
        return new StringBuffer().append('{').append(this.date).append(", P(").append(this.getPosition().getX().getReal()).append(", ").append(this.getPosition().getY().getReal()).append(", ").append(this.getPosition().getZ().getReal()).append("), V(").append(this.getVelocity().getX().getReal()).append(", ").append(this.getVelocity().getY().getReal()).append(", ").append(this.getVelocity().getZ().getReal()).append("), A(").append(this.getAcceleration().getX().getReal()).append(", ").append(this.getAcceleration().getY().getReal()).append(", ").append(this.getAcceleration().getZ().getReal()).append(")}").toString();
    }
}

