/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.javascript.ui.commands;

import java.io.File;
import java.util.HashMap;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgram;
import org.eclipse.apogy.core.programs.javascript.RhinoDebuggerFrontend;
import org.eclipse.apogy.core.programs.javascript.ScriptExecutor;
import org.eclipse.apogy.core.programs.javascript.ui.Activator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ScriptExecutorDebugHandler
extends AbstractHandler {
    private static JavaScriptProgram getJavaScriptProgram(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (!(firstElement instanceof JavaScriptProgram)) {
            return null;
        }
        return (JavaScriptProgram)firstElement;
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        new Job("Debug JavaScriptProgram"){

            protected IStatus run(IProgressMonitor monitor) {
                JavaScriptProgram jsProgram = ScriptExecutorDebugHandler.getJavaScriptProgram(event);
                String projectName = ScriptExecutorDebugHandler.getProjectNameOfJavaScriptProgram(jsProgram);
                ApogyRhinoDebuggerFrontend debug = new ApogyRhinoDebuggerFrontend(projectName);
                try {
                    ScriptExecutor.execute((JavaScriptProgram)jsProgram, (RhinoDebuggerFrontend)debug);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.apogy.core.programs.javascript.ui", e.getMessage()));
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return null;
    }

    private static String getProjectNameOfJavaScriptProgram(JavaScriptProgram program) {
        String scriptPath = program.getScriptPath();
        if (scriptPath == null) {
            return null;
        }
        File file = new File(scriptPath);
        while (file.getParentFile() != null && file.getParentFile().getParentFile() != null) {
            file = file.getParentFile();
        }
        return file.getName();
    }

    class ApogyRhinoDebuggerFrontend
    implements RhinoDebuggerFrontend {
        private static final String LAUNCH_CONFIGURATION_PREFIX = "apogy";
        private static final String REMOTE_JS_SOURCE_LOCATOR_ID = "org.eclipse.wst.jsdt.debug.core.sourceLocator";
        private static final String RHINO_ATTACHING_CONNECTOR_ID = "rhino.attaching.connector";
        private final String projectName;

        public ApogyRhinoDebuggerFrontend(String projectName) {
            this.projectName = projectName;
        }

        public void start(String address, int port) throws CoreException {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = manager.getLaunchConfigurationType("org.eclipse.wst.jsdt.debug.core.launchConfigurationType");
            ILaunchConfigurationWorkingCopy remoteJavaScriptLaunchConfiguration = launchConfigurationType.newInstance(null, manager.generateLaunchConfigurationName(LAUNCH_CONFIGURATION_PREFIX));
            remoteJavaScriptLaunchConfiguration.setAttribute("connector_id", RHINO_ATTACHING_CONNECTOR_ID);
            AbstractSourceLookupDirector sourceLocator = (AbstractSourceLookupDirector)DebugPlugin.getDefault().getLaunchManager().newSourceLocator(REMOTE_JS_SOURCE_LOCATOR_ID);
            ProjectSourceContainer projectSourceContainer = new ProjectSourceContainer(ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName), false);
            sourceLocator.setSourceContainers(new ISourceContainer[]{projectSourceContainer});
            remoteJavaScriptLaunchConfiguration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, sourceLocator.getMemento());
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("host", address);
            arguments.put("port", Integer.toString(port));
            remoteJavaScriptLaunchConfiguration.setAttribute("argument_map", arguments);
            remoteJavaScriptLaunchConfiguration.launch("debug", null);
        }
    }
}

