/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.ObjectAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFactory<S extends ObjectAdapter<T, V, U>, T, V, U> {
    private static final Logger Logger = LoggerFactory.getLogger(AdapterFactory.class);
    private final List<S> adapters;
    private List<Class<?>> classes;
    private Map<Class<?>, S> classesToAdapterMap;

    public AdapterFactory(List<S> adapters) {
        this.adapters = adapters;
    }

    private List<Class<?>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList();
            for (ObjectAdapter adapter : this.adapters) {
                this.getClassesToAdapterMap().put(adapter.getAdaptedClass(), adapter);
                this.classes.add(adapter.getAdaptedClass());
            }
        }
        return this.classes;
    }

    private Map<Class<?>, S> getClassesToAdapterMap() {
        if (this.classesToAdapterMap == null) {
            this.classesToAdapterMap = new HashMap();
        }
        return this.classesToAdapterMap;
    }

    public synchronized S getAdapterFor(V obj) {
        Object adapter = null;
        Iterator<Class<?>> iterator = this.getClasses().iterator();
        Object nodeContent = null;
        if (obj instanceof ContentNode) {
            ContentNode cNode = (ContentNode)obj;
            nodeContent = cNode.getContent();
        } else {
            nodeContent = obj;
        }
        try {
            if (nodeContent != null) {
                for (Class<?> value : this.getClasses()) {
                    Logger.debug(value.getName());
                }
                Class<?> closestMatch = null;
                while (iterator.hasNext()) {
                    Class<?> c = iterator.next();
                    if (!c.isAssignableFrom(nodeContent.getClass())) continue;
                    Logger.debug("\t Found potential match with : " + c.getCanonicalName());
                    if (closestMatch != null && !closestMatch.isAssignableFrom(c)) continue;
                    closestMatch = c;
                }
                Logger.debug("Closest Match : " + closestMatch);
                adapter = (ObjectAdapter)this.getClassesToAdapterMap().get(closestMatch);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.error("Multiple adapters found for <" + obj.getClass().getName() + ">.");
        }
        if (adapter == null) {
            Logger.error("Cannot find an adapter for object of type <" + obj.getClass().getName() + ">!");
        } else {
            Logger.debug("Using adapter <" + adapter.getClass().getName() + "> for class <" + obj.getClass().getName() + ">");
        }
        return (S)adapter;
    }
}

