/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.PositionNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditPositionNodePositionComposite
extends Composite {
    private PositionNode positionNode;
    private Text xValueText = null;
    private Text yValueText = null;
    private Text zValueText = null;

    public EditPositionNodePositionComposite(Composite parent, int style) {
        super(parent, style);
    }

    public EditPositionNodePositionComposite(Composite parent, int style, PositionNode positionNode) {
        super(parent, style);
        this.positionNode = positionNode;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label xLabel = new Label((Composite)this, 0);
        xLabel.setText("X:");
        GridData gridDataX = new GridData();
        gridDataX.widthHint = 100;
        gridDataX.horizontalAlignment = 4;
        this.xValueText = new Text((Composite)this, 2048);
        this.xValueText.setLayoutData((Object)gridDataX);
        this.xValueText.setText(Double.toString(positionNode.getPosition().getX()));
        Label yLabel = new Label((Composite)this, 0);
        yLabel.setText("Y:");
        GridData gridDataY = new GridData();
        gridDataY.widthHint = 100;
        gridDataY.horizontalAlignment = 4;
        this.yValueText = new Text((Composite)this, 2048);
        this.yValueText.setLayoutData((Object)gridDataY);
        this.yValueText.setText(Double.toString(positionNode.getPosition().getY()));
        Label zLabel = new Label((Composite)this, 0);
        zLabel.setText("Z:");
        GridData gridDataZ = new GridData();
        gridDataZ.widthHint = 100;
        gridDataZ.horizontalAlignment = 4;
        this.zValueText = new Text((Composite)this, 2048);
        this.zValueText.setLayoutData((Object)gridDataZ);
        this.zValueText.setText(Double.toString(positionNode.getPosition().getZ()));
        this.setSize(new Point(300, 200));
    }

    public Tuple3d getNewValues() {
        Tuple3d tuple = ApogyCommonMathFacade.INSTANCE.createTuple3d(this.positionNode.getPosition().asTuple3d());
        try {
            double x = Double.parseDouble(this.xValueText.getText());
            double y = Double.parseDouble(this.yValueText.getText());
            double z = Double.parseDouble(this.zValueText.getText());
            tuple = ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z);
        }
        catch (Exception exception) {}
        return tuple;
    }
}

