/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.apogy.common.topology.AbstractNodeVisitor;
import org.eclipse.apogy.common.topology.INodeVisitor;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.composites.AbstractNodeSearchComposite;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class NodeSearchComposite
extends AbstractNodeSearchComposite {
    protected Node topologyRoot = null;

    public NodeSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    public NodeSearchComposite(Composite parent, int style, Node topologyRoot) {
        super(parent, style);
        this.setTopologyRoot(topologyRoot);
    }

    @Override
    protected AdapterFactoryContentProvider createContentProvider() {
        return new NodeContentProvider((AdapterFactory)this.adapterFactory);
    }

    @Override
    protected AdapterFactoryLabelProvider createLabelProvider() {
        return new NodeLabelProvider((AdapterFactory)this.adapterFactory);
    }

    public void setTopologyRoot(Node root) {
        this.topologyRoot = root;
        this.selectedNode = null;
        this.nodeSelectedChanged(null);
        this.applyFilters();
    }

    @Override
    protected Set<Node> getUnfilteredNodes() {
        final HashSet<Node> nodes = new HashSet<Node>();
        if (this.topologyRoot != null) {
            AbstractNodeVisitor visitor = new AbstractNodeVisitor(){

                public void visit(Node node) {
                    nodes.add(node);
                }
            };
            this.topologyRoot.accept((INodeVisitor)visitor);
        }
        return nodes;
    }

    private class NodeContentProvider
    extends AdapterFactoryContentProvider {
        public NodeContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }
    }

    private class NodeLabelProvider
    extends AdapterFactoryLabelProvider {
        public NodeLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            switch (columnIndex) {
                case 0: {
                    if (!(object instanceof Node)) break;
                    str = ((Node)object).getNodeId();
                    break;
                }
                case 1: {
                    if (!(object instanceof Node)) break;
                    str = ((Node)object).getDescription();
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex == 0) {
                return super.getColumnImage(object, columnIndex);
            }
            return null;
        }
    }
}

