/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.AbstractNodeVisitor;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.INodeVisitor;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationSet;
import org.eclipse.apogy.common.topology.ui.impl.ApogyCommonTopologyUIFacadeImpl;

public class ApogyCommonTopologyUIFacadeCustomImpl
extends ApogyCommonTopologyUIFacadeImpl {
    @Override
    public GraphicsContext createGraphicsContext(Node topologyRoot) {
        GraphicsContext graphicsContext = ApogyCommonTopologyUIFactory.eINSTANCE.createGraphicsContext();
        graphicsContext.setTopology(topologyRoot);
        TopologyPresentationSet topologyPresentationSet = Activator.getTopologyPresentationRegistry().createTopologyPresentationSet(topologyRoot);
        graphicsContext.setTopologyPresentationSet(topologyPresentationSet);
        return graphicsContext;
    }

    @Override
    public void findExtent(final Node root, final TopologyPresentationSet topologyPresentationSet, final Tuple3d min, final Tuple3d max) {
        min.setX(Double.POSITIVE_INFINITY);
        min.setY(Double.POSITIVE_INFINITY);
        min.setZ(Double.POSITIVE_INFINITY);
        max.setX(Double.NEGATIVE_INFINITY);
        max.setY(Double.NEGATIVE_INFINITY);
        max.setZ(Double.NEGATIVE_INFINITY);
        AbstractNodeVisitor visitor = new AbstractNodeVisitor(){

            public void visit(Node node) {
                NodePresentation nodePresentation = topologyPresentationSet.getPresentationNode(node);
                if (nodePresentation != null && nodePresentation.isVisible() && nodePresentation.isUseInBoundingCalculation()) {
                    Vector3d v;
                    Tuple3d nodeMin = nodePresentation.getMin();
                    Tuple3d nodeMax = nodePresentation.getMax();
                    Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(node, root);
                    if (nodeMin != null) {
                        v = new Vector3d(nodeMin.asTuple3d());
                        m.transform(v);
                        if (v.x < min.getX()) {
                            min.setX(v.x);
                        }
                        if (v.y < min.getY()) {
                            min.setY(v.y);
                        }
                        if (v.z < min.getZ()) {
                            min.setZ(v.z);
                        }
                    }
                    if (nodeMax != null) {
                        v = new Vector3d(nodeMax.asTuple3d());
                        m.transform(v);
                        if (v.x > max.getX()) {
                            max.setX(v.x);
                        }
                        if (v.y > max.getY()) {
                            max.setY(v.y);
                        }
                        if (v.z > max.getZ()) {
                            max.setZ(v.z);
                        }
                    }
                }
            }
        };
        root.accept((INodeVisitor)visitor);
    }

    @Override
    public NodeSelection createNodeSelection(TopologyPresentationSet topologyPresentationSet, NodePresentation nodePresentation, Point3d relativePosition) {
        NodeSelection nodeSelection = ApogyCommonTopologyUIFactory.eINSTANCE.createNodeSelection();
        nodeSelection.setTopologyPresentationSet(topologyPresentationSet);
        nodeSelection.setSelectedNode(nodePresentation.getNode());
        nodeSelection.setNodePresentation(nodePresentation);
        nodeSelection.setRelativeIntersectionPoint(relativePosition);
        return nodeSelection;
    }

    @Override
    public NodeSelection createNodeSelection(TopologyPresentationSet topologyPresentationSet, Node node, Point3d relativePosition, Vector3f relativeNormal) {
        NodeSelection nodeSelection = ApogyCommonTopologyUIFactory.eINSTANCE.createNodeSelection();
        nodeSelection.setTopologyPresentationSet(topologyPresentationSet);
        nodeSelection.setSelectedNode(node);
        nodeSelection.setRelativeIntersectionPoint(relativePosition);
        nodeSelection.setRelativeIntersectionNormal(relativeNormal);
        return nodeSelection;
    }
}

