/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.impl;

import java.lang.ref.WeakReference;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.SceneObject;
import org.eclipse.apogy.common.topology.ui.impl.NodePresentationImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class NodePresentationCustomImpl
extends NodePresentationImpl {
    private Adapter adapter;
    private final NodePresentationRef ref;

    protected NodePresentationCustomImpl() {
        this.eAdapters().add((Object)this.getAdapter());
        this.ref = new NodePresentationRef(this);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.ref);
    }

    @Override
    public Tuple3d basicGetCentroid() {
        Tuple3d tuple = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        tuple.setX(0.0);
        tuple.setY(0.0);
        tuple.setZ(0.0);
        return tuple;
    }

    @Override
    public Tuple3d basicGetMin() {
        Tuple3d tuple = null;
        if (this.getSceneObject() != null && this.getSceneObject().getMin() != null) {
            tuple = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
            javax.vecmath.Tuple3d min = this.getSceneObject().getMin();
            tuple.setX(min.x);
            tuple.setY(min.y);
            tuple.setZ(min.z);
        }
        return tuple;
    }

    @Override
    public Tuple3d basicGetMax() {
        Tuple3d tuple = null;
        if (this.getSceneObject() != null && this.getSceneObject().getMax() != null) {
            tuple = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
            javax.vecmath.Tuple3d max = this.getSceneObject().getMax();
            tuple.setX(max.x);
            tuple.setY(max.y);
            tuple.setZ(max.z);
        }
        return tuple;
    }

    @Override
    public double getXRange() {
        double range = 0.0;
        if (this.getMin() != null && this.getMax() != null) {
            range = Math.abs(this.getMin().getX() - this.getMax().getX());
        }
        return range;
    }

    @Override
    public double getYRange() {
        double range = 0.0;
        if (this.getMin() != null && this.getMax() != null) {
            range = Math.abs(this.getMin().getY() - this.getMax().getY());
        }
        return range;
    }

    @Override
    public double getZRange() {
        double range = 0.0;
        if (this.getMin() != null && this.getMax() != null) {
            range = Math.abs(this.getMin().getZ() - this.getMax().getZ());
        }
        return range;
    }

    @Override
    public void setSceneObject(SceneObject newSceneObject) {
        boolean updateRequired = newSceneObject != this.sceneObject;
        super.setSceneObject(newSceneObject);
        if (updateRequired) {
            this.initialSceneObject();
        }
    }

    protected void initialSceneObject() {
        this.applyPreferences();
        this.sceneObject.setVisible(this.isVisible());
        this.sceneObject.setColor(this.getColor());
        this.sceneObject.setIDVisible(this.isIdVisible());
        this.sceneObject.setSelected(this.isSelected());
    }

    protected void applyPreferences() {
    }

    protected void updateSceneObject(Notification notification) {
        if (notification.getNotifier() instanceof NodePresentation) {
            int featureId = notification.getFeatureID(NodePresentation.class);
            switch (featureId) {
                case 2: {
                    this.sceneObject.setColor(this.getColor());
                    break;
                }
                case 3: {
                    this.sceneObject.setVisible(this.isVisible());
                    break;
                }
                case 5: {
                    this.sceneObject.setShadowMode(this.getShadowMode());
                    break;
                }
                case 7: {
                    this.sceneObject.setIDVisible(this.isIdVisible());
                    break;
                }
                case 4: {
                    this.sceneObject.setSelected(this.isSelected());
                    break;
                }
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (NodePresentationCustomImpl.this.sceneObject != null) {
                        NodePresentationCustomImpl.this.updateSceneObject(notification);
                    }
                }
            };
        }
        return this.adapter;
    }

    private class NodePresentationRef
    extends WeakReference<NodePresentationCustomImpl>
    implements IPropertyChangeListener {
        public NodePresentationRef(NodePresentationCustomImpl nodePresentation) {
            super(nodePresentation);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.get() != null) {
                ((NodePresentationCustomImpl)this.get()).applyPreferences();
            } else {
                Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }
    }
}

