/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.addons.Trajectory3DTool;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.WayPointPathBinding;
import org.eclipse.apogy.addons.impl.Trajectory3DToolNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class Trajectory3DToolNodeCustomImpl
extends Trajectory3DToolNodeImpl {
    private Adapter adapter = null;
    private final Map<WayPointPath, WayPointPath> sourceToTargetWayPointPath = new HashMap<WayPointPath, WayPointPath>();
    private final Map<WayPointPath, WayPointPathBinding> targetWayPointPathToBinding = new HashMap<WayPointPath, WayPointPathBinding>();

    @Override
    public NotificationChain basicSetTrajectory3DTool(Trajectory3DTool newTrajectory3DTool, NotificationChain msgs) {
        this.internalUpdateTrajectory3DTool(this.trajectory3DTool, newTrajectory3DTool);
        return super.basicSetTrajectory3DTool(newTrajectory3DTool, msgs);
    }

    @Override
    public void setTrajectory3DTool(Trajectory3DTool newTrajectory3DTool) {
        this.internalUpdateTrajectory3DTool(this.trajectory3DTool, newTrajectory3DTool);
        super.setTrajectory3DTool(newTrajectory3DTool);
    }

    private void internalUpdateTrajectory3DTool(Trajectory3DTool oldTrajectory3DTool, Trajectory3DTool newTrajectory3DTool) {
        if (oldTrajectory3DTool != null) {
            oldTrajectory3DTool.eAdapters().remove((Object)this.getAdapter());
            for (WayPointPath wayPointPath : oldTrajectory3DTool.getPaths()) {
                this.removeWayPointPath(wayPointPath);
            }
        }
        this.getChildren().clear();
        if (newTrajectory3DTool != null) {
            for (WayPointPath wayPointPath : newTrajectory3DTool.getPaths()) {
                this.addWayPointPath(wayPointPath);
            }
            newTrajectory3DTool.eAdapters().add((Object)this.getAdapter());
        }
    }

    private void addWayPointPath(WayPointPath wayPointPath) {
        WayPointPath targetWayPointPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        targetWayPointPath.setNodeId(wayPointPath.getNodeId());
        targetWayPointPath.setDescription(wayPointPath.getDescription());
        this.getChildren().add((Object)targetWayPointPath);
        this.sourceToTargetWayPointPath.put(wayPointPath, targetWayPointPath);
        WayPointPathBinding binding = new WayPointPathBinding(wayPointPath, targetWayPointPath);
        this.targetWayPointPathToBinding.put(targetWayPointPath, binding);
    }

    private void removeWayPointPath(WayPointPath wayPointPath) {
        WayPointPath targetWayPointPath = this.sourceToTargetWayPointPath.get(wayPointPath);
        if (targetWayPointPath != null) {
            this.getChildren().remove((Object)targetWayPointPath);
            this.sourceToTargetWayPointPath.remove(wayPointPath);
            WayPointPathBinding binding = this.targetWayPointPathToBinding.get(targetWayPointPath);
            if (binding != null) {
                binding.setTargetWayPointPath(null);
                binding.setSourceWayPointPath(null);
                this.targetWayPointPathToBinding.remove(targetWayPointPath);
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Trajectory3DTool) {
                        int featureId = msg.getFeatureID(Trajectory3DTool.class);
                        block0 : switch (featureId) {
                            case 12: {
                                switch (msg.getEventType()) {
                                    case 3: {
                                        WayPointPath addedPath = (WayPointPath)msg.getNewValue();
                                        Trajectory3DToolNodeCustomImpl.this.addWayPointPath(addedPath);
                                        break block0;
                                    }
                                    case 4: {
                                        WayPointPath removedPath = (WayPointPath)msg.getOldValue();
                                        Trajectory3DToolNodeCustomImpl.this.removeWayPointPath(removedPath);
                                    }
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

