/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.TrajectoryPickingTool;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.WayPointPathBinding;
import org.eclipse.apogy.addons.impl.TrajectoryPickingToolNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;

public class TrajectoryPickingToolNodeCustomImpl
extends TrajectoryPickingToolNodeImpl {
    private Adapter adapter = null;
    private Map<WayPointPath, WayPointPath> sourceToTargetWayPointPath = new HashMap<WayPointPath, WayPointPath>();
    private Map<WayPointPath, WayPointPathBinding> targetWayPointPathToBinding = new HashMap<WayPointPath, WayPointPathBinding>();

    @Override
    protected EClass eStaticClass() {
        return ApogyAddonsPackage.Literals.TRAJECTORY_PICKING_TOOL_NODE;
    }

    @Override
    public NotificationChain basicSetTrajectoryPickingTool(TrajectoryPickingTool newTrajectoryPickingTool, NotificationChain msgs) {
        this.internalUpdateTrajectoryPickingTool(this.trajectoryPickingTool, newTrajectoryPickingTool);
        return super.basicSetTrajectoryPickingTool(newTrajectoryPickingTool, msgs);
    }

    private void internalUpdateTrajectoryPickingTool(TrajectoryPickingTool oldTrajectory3DTool, TrajectoryPickingTool newTrajectory3DTool) {
        if (oldTrajectory3DTool != null) {
            oldTrajectory3DTool.eAdapters().remove((Object)this.getAdapter());
            for (WayPointPath wayPointPath : oldTrajectory3DTool.getPaths()) {
                this.removeWayPointPath(wayPointPath);
            }
        }
        this.getChildren().clear();
        if (newTrajectory3DTool != null) {
            for (WayPointPath wayPointPath : newTrajectory3DTool.getPaths()) {
                this.addWayPointPath(wayPointPath);
            }
            newTrajectory3DTool.eAdapters().add((Object)this.getAdapter());
        }
    }

    private void addWayPointPath(WayPointPath wayPointPath) {
        WayPointPath targetWayPointPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        this.getChildren().add((Object)targetWayPointPath);
        this.sourceToTargetWayPointPath.put(wayPointPath, targetWayPointPath);
        WayPointPathBinding binding = new WayPointPathBinding(wayPointPath, targetWayPointPath);
        this.targetWayPointPathToBinding.put(targetWayPointPath, binding);
    }

    private void removeWayPointPath(WayPointPath wayPointPath) {
        WayPointPath targetWayPointPath = this.sourceToTargetWayPointPath.get(wayPointPath);
        if (targetWayPointPath != null) {
            this.getChildren().remove((Object)targetWayPointPath);
            this.sourceToTargetWayPointPath.remove(wayPointPath);
            WayPointPathBinding binding = this.targetWayPointPathToBinding.get(targetWayPointPath);
            if (binding != null) {
                binding.setTargetWayPointPath(null);
                binding.setSourceWayPointPath(null);
                this.targetWayPointPathToBinding.remove(targetWayPointPath);
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TrajectoryPickingTool) {
                        int featureId = msg.getFeatureID(TrajectoryPickingTool.class);
                        block0 : switch (featureId) {
                            case 10: {
                                switch (msg.getEventType()) {
                                    case 3: {
                                        WayPointPath addedPath = (WayPointPath)msg.getNewValue();
                                        TrajectoryPickingToolNodeCustomImpl.this.addWayPointPath(addedPath);
                                        break block0;
                                    }
                                    case 4: {
                                        WayPointPath removedPath = (WayPointPath)msg.getOldValue();
                                        TrajectoryPickingToolNodeCustomImpl.this.removeWayPointPath(removedPath);
                                    }
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

