/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.telecoms.AbstractAntennaRadiationPattern;
import org.eclipse.apogy.addons.telecoms.ui.Activator;
import org.eclipse.apogy.addons.telecoms.ui.jme3.JME3TelecomsUtilities;
import org.eclipse.apogy.addons.telecoms.ui.jme3.scene_objects.AbstractAntennaRadiationPatternJME3Object;
import org.eclipse.apogy.addons.telecoms.ui.scene_objects.AbstractAntennaRadiationPatternSceneObject;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAntennaRadiationPatternJME3Object
extends AbstractAntennaRadiationPatternJME3Object<AbstractAntennaRadiationPattern>
implements AbstractAntennaRadiationPatternSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(DefaultAntennaRadiationPatternJME3Object.class);
    private final boolean useShading = true;
    private boolean updatingGeometry = false;
    private AssetManager assetManager;
    private Geometry radiationPatternGeometry = null;
    private Geometry axisGeometry = null;
    private Mesh jme3mMesh = null;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.WIREFRAME;
    private final double axisLenght = 1.0;
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    private ColorRGBA meshColor = this.getDefaultMeshColor();
    private Adapter adapter;

    public DefaultAntennaRadiationPatternJME3Object(final AbstractAntennaRadiationPattern abstractAntennaRadiationPattern, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(abstractAntennaRadiationPattern, jme3RenderEngineDelegate);
        if (abstractAntennaRadiationPattern == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.axisGeometry = JME3Utilities.createAxis3D((float)1.0f, (AssetManager)this.assetManager);
        Job job = new Job("AbstractAntennaRadiationPatternJME3Object : Updating Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                final Mesh newMesh = DefaultAntennaRadiationPatternJME3Object.this.createMesh(abstractAntennaRadiationPattern);
                DefaultAntennaRadiationPatternJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        DefaultAntennaRadiationPatternJME3Object.this.updateGeometryInternal(newMesh);
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        ((AbstractAntennaRadiationPattern)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    @Override
    public void updateGeometry(float tpf) {
        Mesh mesh = this.createMesh((AbstractAntennaRadiationPattern)this.getTopologyNode());
        this.updateGeometryInternal(mesh);
    }

    @Override
    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.radiationPatternGeometry);
        return geometries;
    }

    @Override
    public void dispose() {
        ((AbstractAntennaRadiationPattern)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        super.dispose();
    }

    @Override
    public boolean isAxisVisible() {
        return this.axisVisible;
    }

    @Override
    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">.");
        this.axisVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (DefaultAntennaRadiationPatternJME3Object.this.axisVisible && !DefaultAntennaRadiationPatternJME3Object.this.getAttachmentNode().hasChild((Spatial)DefaultAntennaRadiationPatternJME3Object.this.axisGeometry)) {
                    DefaultAntennaRadiationPatternJME3Object.this.getAttachmentNode().attachChild((Spatial)DefaultAntennaRadiationPatternJME3Object.this.axisGeometry);
                } else if (DefaultAntennaRadiationPatternJME3Object.this.getAttachmentNode().hasChild((Spatial)DefaultAntennaRadiationPatternJME3Object.this.axisGeometry)) {
                    DefaultAntennaRadiationPatternJME3Object.this.getAttachmentNode().detachChild((Spatial)DefaultAntennaRadiationPatternJME3Object.this.axisGeometry);
                }
                return null;
            }
        });
    }

    @Override
    public double getAxisLength() {
        return 1.0;
    }

    @Override
    public void setAxisLength(final double length) {
        if (length > 0.0) {
            Logger.info("Setting axis length to <" + length + ">.");
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        float scale = (float)Math.abs(length) / DefaultAntennaRadiationPatternJME3Object.this.previousAxisLength;
                        if (DefaultAntennaRadiationPatternJME3Object.this.axisGeometry != null) {
                            DefaultAntennaRadiationPatternJME3Object.this.axisGeometry.scale(scale);
                        }
                        DefaultAntennaRadiationPatternJME3Object.this.previousAxisLength = (float)length;
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to setAxisLength(" + length + ").", t);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Setting axis length to <" + length + ">  failed : Length must be greater than zero.");
        }
    }

    @Override
    public MeshPresentationMode getPresentationMode() {
        return this.meshPresentationMode;
    }

    @Override
    public void setPresentationMode(final MeshPresentationMode mode) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DefaultAntennaRadiationPatternJME3Object.this.internalSetPresentationMode(mode);
                return null;
            }
        });
    }

    @Override
    public void setColor(final RGBA rgb) {
        Logger.info("Set Color <" + rgb + ")");
        super.setColor(rgb);
        this.meshColor = new ColorRGBA((float)rgb.rgb.red, (float)rgb.rgb.green, (float)rgb.rgb.blue, (float)rgb.alpha);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (DefaultAntennaRadiationPatternJME3Object.this.radiationPatternGeometry != null) {
                        Material mat = DefaultAntennaRadiationPatternJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", DefaultAntennaRadiationPatternJME3Object.this.meshColor.clone());
                        mat.setColor("Ambient", DefaultAntennaRadiationPatternJME3Object.this.meshColor.clone());
                        mat.setColor("Specular", DefaultAntennaRadiationPatternJME3Object.this.meshColor.clone());
                        DefaultAntennaRadiationPatternJME3Object.this.radiationPatternGeometry.setMaterial(mat);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to set color to <" + rgb + ">.", t);
                }
                return null;
            }
        });
    }

    @Override
    protected void updateGeometryInternal(Mesh newMesh) {
        try {
            if (!this.updatingGeometry) {
                this.updatingGeometry = true;
                if (this.radiationPatternGeometry != null) {
                    this.getAttachmentNode().detachChild((Spatial)this.radiationPatternGeometry);
                }
                this.jme3mMesh = newMesh;
                if (this.jme3mMesh != null) {
                    this.radiationPatternGeometry = ((AbstractAntennaRadiationPattern)this.getTopologyNode()).getNodeId() != null ? new Geometry(((AbstractAntennaRadiationPattern)this.getTopologyNode()).getNodeId(), this.jme3mMesh) : new Geometry("AbstractAntennaRadiationPattern", this.jme3mMesh);
                    this.radiationPatternGeometry.setMaterial(this.createMaterial());
                    this.radiationPatternGeometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    this.getAttachmentNode().attachChild((Spatial)this.radiationPatternGeometry);
                }
                this.updatingGeometry = false;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    @Override
    protected Material createMaterial() {
        Material mat = null;
        mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.meshColor != null) {
            mat.setColor("Diffuse", this.meshColor);
            mat.setColor("Ambient", this.meshColor);
            mat.setColor("Specular", this.meshColor);
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        return mat;
    }

    @Override
    protected Mesh createMesh(AbstractAntennaRadiationPattern abstractAntennaRadiationPattern) {
        return JME3TelecomsUtilities.createAntennaPattern(abstractAntennaRadiationPattern);
    }

    @Override
    protected ColorRGBA getDefaultMeshColor() {
        ColorRGBA rgba = null;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"ABSTRACT_ANTENNA_RADIATION_PATTERN_COLOR_ID");
        rgba = rgb != null ? JME3Utilities.convertToColorRGBA((RGB)rgb) : new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
        return rgba;
    }

    @Override
    protected void internalSetPresentationMode(MeshPresentationMode mode) {
        switch (mode.getValue()) {
            case 1: {
                if (this.radiationPatternGeometry == null || this.radiationPatternGeometry.getMaterial() == null) break;
                Mesh mesh = this.radiationPatternGeometry.getMesh();
                this.radiationPatternGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                if (mesh == null) break;
                mesh.setMode(Mesh.Mode.Triangles);
                break;
            }
            case 2: {
                if (this.radiationPatternGeometry == null || this.radiationPatternGeometry.getMaterial() == null) break;
                Mesh mesh = this.radiationPatternGeometry.getMesh();
                this.radiationPatternGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                if (mesh == null) break;
                mesh.setMode(Mesh.Mode.Lines);
                break;
            }
            case 0: {
                if (this.radiationPatternGeometry == null || this.radiationPatternGeometry.getMaterial() == null) break;
                Mesh mesh = this.radiationPatternGeometry.getMesh();
                this.radiationPatternGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                if (mesh == null) break;
                mesh.setMode(Mesh.Mode.Points);
                break;
            }
        }
        this.meshPresentationMode = mode;
    }

    @Override
    protected Adapter createAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                final Mesh newMesh = DefaultAntennaRadiationPatternJME3Object.this.createMesh((AbstractAntennaRadiationPattern)DefaultAntennaRadiationPatternJME3Object.this.getTopologyNode());
                DefaultAntennaRadiationPatternJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            DefaultAntennaRadiationPatternJME3Object.this.updateGeometryInternal(newMesh);
                        }
                        catch (Exception exception) {}
                        return null;
                    }
                });
            }
        };
    }

    private final Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = this.createAdapter();
        }
        return this.adapter;
    }
}

