/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.impl;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.eclipse.apogy.common.images.impl.ApogyCommonImagesFactoryImpl;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonImagesFactoryCustomImpl
extends ApogyCommonImagesFactoryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonImagesFactoryImpl.class);

    @Override
    public ImageData createImageDataFromString(EDataType eDataType, String initialValue) {
        byte[] data = DataValue.Base64.decode((String)initialValue);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ImageLoader loader = new ImageLoader();
        ImageData imageData = loader.load((InputStream)inputStream)[0];
        return imageData;
    }

    @Override
    public String convertImageDataToString(EDataType eDataType, Object instanceValue) {
        ImageData imageData = (ImageData)instanceValue;
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        loader.save((OutputStream)outputStream, 4);
        String data = DataValue.Base64.encode((byte[])outputStream.toByteArray());
        return data;
    }

    @Override
    public BufferedImage createBufferedImageFromString(EDataType eDataType, String initialValue) {
        byte[] data = DataValue.Base64.decode((String)initialValue);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (Exception e) {
            Logger.error("Failed to load BufferedImage from string.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String convertBufferedImageToString(EDataType eDataType, Object instanceValue) {
        try {
            BufferedImage bufferedImage = (BufferedImage)instanceValue;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            String data = DataValue.Base64.encode((byte[])outputStream.toByteArray());
            return data;
        }
        catch (Exception e) {
            Logger.error("Failed to convert BufferedImage to string.", (Throwable)e);
            return null;
        }
    }
}

