/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.eclipse.apogy.common.images.impl.URLEImageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLEImageCustomImpl
extends URLEImageImpl {
    private static final Logger Logger = LoggerFactory.getLogger(URLEImageImpl.class);
    private boolean dirty = true;
    private BufferedImage bufferedImage = null;

    @Override
    public void setUrl(String newUrl) {
        this.dirty = true;
        super.setUrl(newUrl);
    }

    @Override
    public BufferedImage asBufferedImage() {
        if (this.dirty || this.bufferedImage == null) {
            this.bufferedImage = this.loadBufferedImage();
            this.dirty = false;
        }
        return this.bufferedImage;
    }

    @Override
    public int getWidth() {
        if (this.asBufferedImage() != null) {
            return this.asBufferedImage().getWidth();
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.asBufferedImage() != null) {
            return this.asBufferedImage().getHeight();
        }
        return 0;
    }

    protected BufferedImage loadBufferedImage() {
        BufferedImage bufferedImage = null;
        try {
            URL url = new URL(this.getUrl());
            File tempFile = this.copyURLContent(url);
            bufferedImage = ImageIO.read(tempFile);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            Logger.error("Error occured while loading image data from <" + this.getUrl() + ">!", (Throwable)e);
            bufferedImage = null;
        }
        return bufferedImage;
    }

    public String getFileName(URL url) {
        String fileName = url.getFile();
        int startIndex = fileName.lastIndexOf(File.separator);
        int endIndex = fileName.lastIndexOf(".");
        if (startIndex > 0 && endIndex > 0) {
            fileName = fileName.substring(startIndex + 1, endIndex);
        }
        return fileName;
    }

    public String getFileExtension(URL url) {
        String fileExtension = url.getFile();
        int index = fileExtension.lastIndexOf(".");
        if (index > 0) {
            fileExtension = fileExtension.substring(index);
        }
        return fileExtension;
    }

    public File copyURLContent(URL url) {
        File tempFile = null;
        try {
            String fileName = this.getFileName(url);
            String fileExtension = this.getFileExtension(url);
            tempFile = File.createTempFile(fileName, fileExtension);
            url.openConnection();
            InputStream reader = url.openStream();
            FileOutputStream writer = new FileOutputStream(tempFile);
            byte[] buffer = new byte[153600];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[153600];
            }
            writer.close();
            reader.close();
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        if (tempFile != null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }
}

